/*!
 	@file
 	@brief WXgL[擾E쐬NX
*/

#ifndef CRegistry_h
#define CRegistry_h

#include"../../Setup/CompileMode.h"
#include"../../Setup/Win32.h"
#include"../Macro.h"
#include"../mstring.h"
#include"../Debug/CException.h"

#include<boost/smart_ptr.hpp>

namespace Maid
{
	class CRegistry
	{
	public:
		CRegistry();
		~CRegistry();

		enum KEY
		{
			KEY_CLASSES_ROOT,
			KEY_CURRENT_USER,
			KEY_LOCAL_MACHINE,
			KEY_USERS,
		};

		void Open( KEY hKey, const mstring& SubKey );
		void Create( KEY hKey, const mstring& SubKey );

		void SetValue( const mstring& Name, unt32 Data );
		void SetValue( const mstring& Name, const mstring& Data );
		void SetValue( const mstring& Name, const void* pData, unt32 Length );

		void GetValue( const mstring& Name, unt32& Data );
		void GetValue( const mstring& Name, mstring& Data );
		void GetValue( const mstring& Name, boost::shared_array<unt08>& pData, unt32& Length );

		void DeleteValue( const mstring& ValueName );

		static void DeleteKey( KEY hKey, const mstring& SubKey );
		static void DeleteValue( KEY hKey, const mstring& SubKey, const mstring& ValueName );
	private:
		void	Close();

		HKEY	m_hKey;
	};
}

#endif
