/*!
 	@file
 	@brief	eP̃VFW
\n			قƂǂbnlgĂ̂ CoInitilize YȂ
 */


#ifndef CShell_h
#define CShell_h

#include"../../Setup/CompileMode.h"
#include"../../Setup/Win32.h"
#include"../Macro.h"
#include"../mstring.h"
#include"../Debug/CException.h"

#include<vector>
#include<list>
#include<boost/smart_ptr.hpp>

namespace Maid
{
	namespace CShell
	{
		void CoInitialize();
		void CoUninitialize();

		void InitCommonControls();

		mstring GetProgramFilesFolder( HWND hWnd );
		mstring GetDeskTopFolder( HWND hWnd );
		mstring GetProgramMenuFolder( HWND hWnd );
		mstring GetApplicationDataFolder( HWND hWnd );
		mstring GetMyDocumentsFolder( HWND hWnd );
		mstring GetWindowsFolder();
		mstring GetCurrentDirectory();
		mstring GetExeFileName();
		mstring GenerateUniqueName();

		bool IsExistFile( const mstring& FilePath );
		bool IsExistDirectory( const mstring& FilePath );
		unt	GetFileSize( const mstring& FilePath );

		void SetCurrentDirectory( const mstring& FilePath );

		void CreateShortCut( const mstring& ShortCutPath, const mstring& TargetPath, const mstring& CommandLine );
		void CreateDirectory( const mstring& DirectoryPath );
		void CreateDirectory( const mstring& DirectoryPath, MySTL::vector<mstring>& CreateList );

		void CopyFile( const mstring& SrcPath, const mstring& DstPath );
		void DeleteFile( const mstring& FileName );
		void DeleteDirectory( const mstring& DirectoryName );
		mstring WinAPI_SHGetSpecialFolderLocation( HWND hWnd, int nFolder );

		mstring GetLastErrorString();

		mstring DeviceCapsStringOut();


		enum WINDOWSVERSION
		{
			WINDOWSVERSION_95=0x010000,
			WINDOWSVERSION_98,
			WINDOWSVERSION_ME,

			WINDOWSVERSION_NT=0x020000,
			WINDOWSVERSION_2000_PROFESSIONAL,
			WINDOWSVERSION_2000_SERVER,
			WINDOWSVERSION_XP_HOME,
			WINDOWSVERSION_XP_PROFESSIONAL,
			WINDOWSVERSION_XP_DOTNETSERVER,

			WINDOWSVERSION_VISTA,

			WINDOWSVERSION_NOTFOUND=0xFF,
		};


		WINDOWSVERSION	GetWindowsVersion();
		bool			IsWindowsVersion9x();
		bool			IsWindowsVersionNT();


		mstring BrowseForFolder( HWND hWnd, const mstring& Title, const mstring& DefaultFolder=mstring() );



		class CFindObject
		{
		public:
			CFindObject();
			CFindObject( WIN32_FIND_DATA& rData );

			enum TYPE
			{
				TYPE_FILE,			//!<	ʂ̃t@C
				TYPE_DIRECTORY,		//!<	fBNg
				TYPE_UNKOWN,		//!<	킩܂
			};

			TYPE	GetFileType() const ;
			mstring	GetFileName() const ;

		private:
			WIN32_FIND_DATA	m_FindData;
		};

		class CPickupFileFilter
		{
		public:
			virtual ~CPickupFileFilter(){}
			virtual bool IsPassage( const CFindObject& Data ){return true;}
		};

		typedef boost::shared_ptr<CPickupFileFilter> SPPICKUPFILEFILTER;
		typedef MySTL::list<CFindObject>			FINDOBJECTLIST;

		FINDOBJECTLIST PickupFile( const mstring& Path );
		FINDOBJECTLIST PickupFile( const mstring& Path, const SPPICKUPFILEFILTER& pFilter );





	}
}

#endif