#include"CXMLNode.h"
#include"../Debug/CAssert.h"
#include"../CString.h"



namespace Maid
{
	/*!
	 	@class	CXMLValue CXMLNode.h
	 	@brief	XML̒l\eLXg
	\n			eLXglϊ̃bpł
	 */

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!
 */
CXMLText::CXMLText()
{
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!
 	@param	Text	[i ]	eLXgBꂪ<a>XXX</a>  XXX̕ł
 */
CXMLText::CXMLText( const mstring& Text ) : m_Text(Text)
{
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ĂeLXgint^ƂĎ擾
/*!
 	@return intBeLXg
 */
int CXMLText::GetInt() const
{
	return CString::AtoI(m_Text);
}


float CXMLText::GetFloat() const
{
	return CString::AtoF(m_Text);
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ĂeLXg擾
/*!
 	@return eLXg
 */
const mstring& CXMLText::GetStr() const
{
	return m_Text;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! eLXgĂȂH
/*!
 	@return ȂȂ true
 */
bool CXMLText::IsEmpty() const
{
	return m_Text.empty();
}



	/*!
	 	@class	CXMLNode CXMLNode.h
	 	@brief	XML̃m[h
	\n			CXMLDocument ɂԂ牺Ăm[hłB
	 */

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!
 */
CXMLNode::CXMLNode()
{
	m_Type   = TYPE_EMPTY;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! m[h̖O̎擾
/*!
 	@return m[h
 */
mstring CXMLNode::GetName() const
{
	return m_Name;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! m[h̎ނ̎擾
/*!
 	@return m[h^Cv
 */
CXMLNode::TYPE CXMLNode::GetType() const
{
	return m_Type;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ̑Ă邩H
/*!
 	@return ̌
 */
int CXMLNode::GetAttributeLength()const
{
	return (int)m_AttributeList.size();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! w肵̎擾
/*!
 	@return Bw肵̂ȂȂNULL
 */
CXMLText CXMLNode::GetAttribute( const mstring& Name )const
{
	ATTRIBUTELIST::const_iterator ite = m_AttributeList.find(Name);

	if( ite==m_AttributeList.end() ) { return CXMLText(); }
	return (ite->second);
}

const CXMLNode::ATTRIBUTELIST& CXMLNode::GetAttributeTable() const
{
	return m_AttributeList;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! eLXg̎擾
/*!
 	@return eLXg
 */
CXMLText	CXMLNode::GetText() const
{
	MAID_ASSERT( m_Type!=TYPE_TEXT, "̃m[h̓eLXg^Cvł͂܂" );
	return m_Text;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ^O̎擾
/*!
 	@return ^O
 */
mstring CXMLNode::GetElementName() const
{
	MAID_ASSERT( m_Type!=TYPE_ELEMENT, "̃m[h̓^O^Cvł͂܂" );
	return m_Name;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Rg̎擾
/*!
 	@return Rg
 */
mstring CXMLNode::GetComment() const
{
	MAID_ASSERT( m_Type!=TYPE_COMMENT, "̃m[h̓Rg^Cvł͂܂" );
	return m_Text.GetStr();
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ̃m[h͋ۂH
/*!
 	@return Ȃtrue
 */
bool CXMLNode::IsEmpty() const
{
	return m_Type == TYPE_EMPTY;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! qm[h邩H
/*!
 *	\return qm[ȟ
 */
int  CXMLNode::GetChildLength() const
{
	MAID_ASSERT( m_Type!=TYPE_ELEMENT, "̃m[h͗vf^Cvł͂܂" );
	return (int)m_ChildList.size();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! qm[h̎擾
/*!
 	@return qm[hB
 */
CXMLNode&	CXMLNode::GetChildNode( int index ) const
{
	MAID_ASSERT( m_Type!=TYPE_ELEMENT, "̃m[h͗vf^Cvł͂܂" );
	MAID_ASSERT( !(index<(int)m_ChildList.size()), "͈͊Oł " << index );
	return *(m_ChildList[index]);
}


void CXMLNode::SetElementName( const mstring& Name )
{
	m_Name = Name;
	m_Type = TYPE_ELEMENT;
}

void CXMLNode::SetText( const mstring& Text )
{
	m_ChildList.clear();
	m_Text = CXMLText(Text);
	m_Type = TYPE_TEXT;
}

void CXMLNode::SetComment( const mstring& Text )
{
	m_ChildList.clear();
	m_Text = CXMLText(Text);
	m_Type = TYPE_COMMENT;
}

void CXMLNode::SetAttribute( const mstring& Name, const CXMLText& Value )
{
	m_AttributeList[Name] = Value;
}

void CXMLNode::DeleteAttribute( const mstring& Name )
{
	m_AttributeList.erase( m_AttributeList.find(Name) );
}


void CXMLNode::AddChildNode( const SPXMLNODE& pNode )
{
	m_ChildList.push_back( pNode );
}


void CXMLNode::InsertChildNode( int Index, const SPXMLNODE& pNode )
{
	m_ChildList.insert( m_ChildList.begin()+Index, pNode );
}

void CXMLNode::DeleteChildNode( int Index )
{
	m_ChildList.erase( m_ChildList.begin()+Index );
}

void CXMLNode::SetChildNode( int Index, const SPXMLNODE& pNode )
{
	MAID_ASSERT( (int)m_ChildList.size()>=Index, "͈͊Oł" );
	m_ChildList[Index] = pNode;
}

}

