#include"CGUIParts.h"
#include"CGUIManager.h"

namespace Maid
{
	/*!
	 *	\class	IGUIParts CGUIParts.h
	 *	\brief	fthp[c{NX
	 */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!
 *
 */
IGUIParts::IGUIParts()
{
	m_PartsID = GUIID_NONE;
	m_pOwner  = NULL;
	m_Position = VECTOR2DI(0,0);

	m_IsEnable  = true;
	m_IsVisible = true;
	m_IsFocus   = false;
	m_IsMouseIn = false;
}

IGUIParts::IGUIParts( const IGUIParts& parts )
{
	m_PartsID = parts.m_PartsID;
	m_pOwner  = NULL;
	m_Position = parts.m_Position;

	m_IsEnable  = parts.m_IsEnable;
	m_IsVisible = parts.m_IsVisible;
	m_IsFocus   = false;
	m_IsMouseIn = false;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fXgN^
/*!
 *
 */
IGUIParts::~IGUIParts()
{
	if( m_pOwner!=NULL )
	{
		m_pOwner->DeleteGUIParts( m_PartsID );
		m_pOwner = NULL;
	}
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ̃p[c̐ݒuW̐ݒ
/*!	̃p[cǗĂ CGUIManager ̑΍WɂȂ܂
 *
 *	\param	x	[i ]	VWw
 *	\param	y	[i ]	VWx
 *
 */
void   IGUIParts::SetPos( int32 x, int32 y )
{
	m_Position.x = x;
	m_Position.y = y;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Ԃ̕ύX
/*!	SetEnable(), SetVisible() 𓯎ɍs֐ł
 *
 *	\param	IsEnable	[i ]	sH
 *	\param	IsVisible	[i ]	`sH
 *
 */
void IGUIParts::SetState( bool IsEnable, bool IsVisible )
{
	m_IsEnable = IsEnable;
	m_IsVisible = IsVisible;
	OnLocalChangeState( m_IsEnable, m_IsVisible);
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Ԃ̕ύX
/*!	OnLocalMove() Ă΂邩̐ݒ
 *
 *	\param	IsEnable	[i ]	sH
 */
void IGUIParts::SetEnable( bool IsEnable )
{
	m_IsEnable = IsEnable;
	OnLocalChangeState( m_IsEnable, m_IsVisible);
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Ԃ̕ύX
/*!	OnLocalDraw() Ă΂邩̐ݒ
 *
 *	\param	IsVisible	[i ]	`sH
 */
void IGUIParts::SetVisible( bool IsVisible )
{
	m_IsVisible = IsVisible;
	OnLocalChangeState( m_IsEnable, m_IsVisible);
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! R[obN֐̐ݒ
/*!	
 *	\param	CallBack	[i ]	ݒ肷֐
 */
void IGUIParts::SetCallBack( const GUIMESSAGEFUNCTION& CallBack )
{
	m_Function = CallBack;
}

void IGUIParts::ClearCallBack()
{
	m_Function.clear();
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! p[chc̐ݒ
/*!	
 *	\param	PartsID	[i ]	Vp[chc
 */
void IGUIParts::SetID( unt32 PartsID )
{
	m_PartsID = PartsID;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ݂̃p[cW̎擾
/*!	̃p[cǗĂ CGUIManager ̑΍WɂȂ܂
 *
 *	\return	wW
 */
int32 IGUIParts::GetPosX() const
{
	return m_Position.x;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ݂̃p[cW̎擾
/*!	̃p[cǗĂ CGUIManager ̑΍WɂȂ܂
 *
 *	\return	xW
 */
int32 IGUIParts::GetPosY() const
{
	return m_Position.y;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! p[chc̎擾
/*!	
 *	\return	p[chc
 */
unt32 IGUIParts::GetID() const
{
	return m_PartsID;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t[̏s邩H
/*!
 *	\return	sȂ true
 */
bool IGUIParts::IsEnable() const
{
	return m_IsEnable;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t[̕`s邩H
/*!
 *	\return	sȂ true
 */
bool IGUIParts::IsVisible()const
{
	return m_IsVisible;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t[̏
/*!
 */
void IGUIParts::OnMove()
{
	if( !IsEnable() ) { return ; }
	OnLocalMove();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t[̕`
/*!
 *	\param	Offset	[i ]	̃p[cǗĂ CGUImanager ̍W
 *	\param	Render	[i ]	_
 *	\param	Dst		[i ]	`
 */
void IGUIParts::OnDraw( const POINT2DI& Offset, CGraphic& Render )
{
	if( !IsVisible() ) { return ; }
	OnLocalDraw( Offset+m_Position, Render );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ̃p[cɃJ[\邩H
/*!
 *	\param	pos	[i ]	J[\W
 */
bool IGUIParts::IsCollision( const POINT2DI& pos ) const
{
	if( !IsEnable() ) { return false; }
	return IsLocalCollision( pos-m_Position );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! }EXJ[\p[cɓɌĂ΂
/*!
 *	\param	pos	[i ]	J[\W
 */
void IGUIParts::OnMouseIn  ( const POINT2DI& pos )
{
	if( !IsEnable() ) { return; }
	m_IsMouseIn = true;
	OnLocalMouseIn( pos-m_Position );
	CallBack( GUIMESSAGE_PARTS_MOUSEIN  );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! }EXJ[\p[coɌĂ΂
/*!
 *	\param	pos	[i ]	J[\W
 */
void IGUIParts::OnMouseOut ( const POINT2DI& pos )
{
	if( !IsEnable() ) { return; }
	if( !m_IsMouseIn ) { return ; }
	OnLocalMouseOut( pos-m_Position );
	m_IsMouseIn = false;
	CallBack( GUIMESSAGE_PARTS_MOUSEOUT  );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! }EX̃{^ꂽɌĂ΂
/*!
 *	\param	pos	[i ]	J[\W
 */
void IGUIParts::OnMouseDown( const POINT2DI& pos )
{
	if( !IsEnable() ) { return; }
	OnLocalMouseDown( pos-m_Position );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! }EX̃{^ꂽɌĂ΂
/*!
 *	\param	pos	[i ]	J[\W
 */
void IGUIParts::OnMouseUp  ( const POINT2DI& pos )
{
	if( !IsEnable() ) { return ; }
	OnLocalMouseUp( pos-m_Position );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! }EX̃J[\ɌĂ΂
/*!
 *	\param	pos	[i ]	J[\W
 */
void IGUIParts::OnMouseMove( const POINT2DI& pos )
{
	if( !IsEnable() ) { return ; }
	OnLocalMouseMove( pos-m_Position );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! L[{[h̃L[ꂽɌĂ΂
/*!
 *	\param	KeyCode	[i ]	L[R[h
 */
void IGUIParts::OnKeyDown( unt08 KeyCode )
{
	if( !IsEnable() ) { return ; }
	OnLocalKeyDown( KeyCode );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! L[{[h̃L[͂ȂꂽɌĂ΂
/*!
 *	\param	KeyCode	[i ]	L[R[h
 */
void IGUIParts::OnKeyUp( unt08 KeyCode )
{
	if( !IsEnable() ) { return ; }
	OnLocalKeyUp( KeyCode );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! R[h͂ꂽɌĂ΂
/*!
 *	\param	CharCode	[i ]	R[h
 */
void IGUIParts::OnCharCode( const mstring& CharCode )
{
	if( !IsEnable() ) { return ; }
	OnLocalCharCode( CharCode );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ̃NXɃtH[JXoƂɌĂ΂
/*!
 */
void IGUIParts::OnFocusIn()
{
	if( !IsEnable() ) { return ; }

	m_IsFocus = true;
	OnLocalFocusIn();

	CallBack( GUIMESSAGE_PARTS_FOCUSIN  );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ̃NXtH[JXƂɌĂ΂
/*!
 */
void IGUIParts::OnFocusOut()
{
	if( !IsEnable() ) { return ; }

	m_IsFocus = false;
	OnLocalFocusOut();
	CallBack( GUIMESSAGE_PARTS_FOCUSOUT );
}



/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! bZ[W𔭍s
/*!
 *	\param	msg	[i ]	bZ[We
 */
void IGUIParts::CallBack( GUIMESSAGE msg )
{
	MAID_ASSERT( !m_Function, "R[obN̐ݒ肪Ă܂" );
	if( !m_Function ) { return ; }
	m_Function( m_PartsID, msg );
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ݃tH[JXĂ邩H
/*!
 *	\return ĂȂ true
 */
bool IGUIParts::IsFocusIn() const
{
	return m_IsFocus;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ݃GfBbg[hH
/*!
 *	\return GfBbg[hȂ true
 */
bool IGUIParts::IsMouseIn() const
{
	return m_IsMouseIn;
}

}
