/*!
 	@file
 	@brief	fthp[c{NX
 */
#ifndef CGUIParts_h
#define CGUIParts_h

#include"CGUIPartsDefine.h"

namespace Maid
{
	class CGUIManager;
	class IGUIParts
	{
		friend CGUIManager;
	public:
		IGUIParts();
		IGUIParts( const IGUIParts& parts );
		~IGUIParts();


		void   SetPos( const POINT2DI& pos ) { SetPos(pos.x,pos.y); }
		void   SetPos( int32 x, int32 y );
		int32 GetPosX() const;
		int32 GetPosY() const;
		unt32 GetID() const;

		void SetState( bool IsEnable, bool IsVisible );
		void SetEnable( bool IsEnable );
		void SetVisible( bool IsVisible );

		void SetCallBack( const GUIMESSAGEFUNCTION& CallBack );
		void ClearCallBack();
		void SetID( unt32 PartsID );

		bool IsEnable() const;
		bool IsVisible()const;

		void OnMove();
		void OnDraw( const POINT2DI& Offset, CGraphic& Render );

		bool IsCollision( const POINT2DI& pos ) const;


		void OnMouseIn  ( const POINT2DI& pos );
		void OnMouseOut ( const POINT2DI& pos );
		void OnMouseDown( const POINT2DI& pos );
		void OnMouseUp  ( const POINT2DI& pos );
		void OnMouseMove( const POINT2DI& pos );
		void OnKeyUp( unt08 KeyCode );
		void OnKeyDown( unt08 KeyCode );
		void OnCharCode( const mstring& CharCode );
		void OnFocusIn ();
		void OnFocusOut();

		bool IsFocusIn() const;
		bool IsMouseIn() const;

	protected:
		//! t[̏
		/*!
		 */
		virtual void OnLocalMove()=0;

		//! t[̕`
		/*!
		 *	\param	pos		[i ]	`Wi΍W
		 *	\param	Render	[i ]	_
		 *	\param	Dst		[i ]	`Ώې
		 */
		virtual void OnLocalDraw( const POINT2DI& pos, CGraphic& Render )=0;

		//! ̃p[cɃJ[\邩H
		/*!
		 *	\param	pos	[i ]	J[\W
		 */
		virtual bool IsLocalCollision( const POINT2DI& pos ) const=0;
		//! }EXJ[\p[cɓɌĂ΂
		/*!
		 *	\param	pos	[i ]	J[\W
		 */
		virtual void OnLocalMouseIn( const POINT2DI& pos )=0;
		//! }EXJ[\p[coɌĂ΂
		/*!
		 *	\param	pos	[i ]	J[\W
		 */
		virtual void OnLocalMouseOut ( const POINT2DI& pos )=0;


		//! }EX̃{^ꂽɌĂ΂
		/*!
		 *	\param	pos	[i ]	J[\W
		 */
		virtual void OnLocalMouseDown( const POINT2DI& pos )=0;
		//! }EX̃{^ꂽɌĂ΂
		/*!
		 *	\param	pos	[i ]	J[\W
		 */
		virtual void OnLocalMouseUp  ( const POINT2DI& pos )=0;
		//! }EX̃J[\ɌĂ΂
		/*!
		 *	\param	pos	[i ]	J[\W
		 */
		virtual void OnLocalMouseMove( const POINT2DI& pos )=0;

		//! L[{[h̃L[͂ȂꂽɌĂ΂
		/*!
		 *	\param	KeyCode	[i ]	L[R[h
		 */
		virtual void OnLocalKeyUp( unt08 KeyCode )=0;

		//! L[{[h̃L[ꂽɌĂ΂
		/*!
		 *	\param	KeyCode	[i ]	L[R[h
		 */
		virtual void OnLocalKeyDown( unt08 KeyCode )=0;

		//! R[h͂ꂽɌĂ΂
		/*!
		 *	\param	CharCode	[i ]	R[h
		 */
		virtual void OnLocalCharCode( const mstring& CharCode )=0;

		//! ԂύXꂽƂɌĂ΂
		/*!
		 *	\param	NewStateEnable	[i ]	V
		 *	\param	NewStateVisible	[i ]	V
		 */
		virtual void OnLocalChangeState( bool NewStateEnable, bool NewStateVisible )=0;


		//! ̃NXɃtH[JXƂɌĂ΂
		/*!
		 */
		virtual void OnLocalFocusIn(){};

		//! ̃NXtH[JXƂɌĂ΂
		/*!
		 */
		virtual void OnLocalFocusOut(){};

		void CallBack( GUIMESSAGE msg );

		CGUIManager*	GetOwner() { return m_pOwner; }

	private:
		GUIMESSAGEFUNCTION	m_Function;			//!<	̂fthp[cŋNbZ[W̑M
		unt32			m_PartsID;				//!<	̂fthp[ĉhc
		CGUIManager*	m_pOwner;				//!<	I[i[
		VECTOR2DI		m_Position;				//!<	̂fthWi m_pOwner ̑΍W )
		bool			m_IsEnable;				//!<	OnMove() ĂяoĂ
		bool			m_IsVisible;			//!<	OnDraw() ĂяoĂ
		bool			m_IsFocus;				//!<	݃tH[JXĂ邩H
		bool			m_IsMouseIn;			//!<	}EXĂ邩H
	};


}

#endif
