/*!
 *	\file
 *	\brief	fthp[c XC_NX
 *
 */
#ifndef CGUISlider_h
#define CGUISlider_h

#include"CGUIParts.h"

namespace Maid
{

	class IGUISlider : public IGUIParts
	{
	public:
		class Listener
		{
			friend IGUISlider;
		public:
			virtual ~Listener(){}
			virtual bool IsCollisionBar( const POINT2DI& pos )const=0;		//!<	XC_o[͈͓̔ɃJ[\邩
			virtual bool IsCollisionButton( const POINT2DI& pos )const=0;	//!<	XC_{^͈͓̔ɃJ[\邩
			virtual void OnMove(){}
			virtual void OnDraw( const POINT2DI& BarPos, const POINT2DI& ButtonPos, CGraphic& Render ){}
			virtual void OnFocusIn(){}
			virtual void OnFocusOut(){}

			virtual void OnButtonDown(){}
			virtual void OnButtonUp(){}
			virtual void OnMouseIn(){}
			virtual void OnMouseOut(){}

			virtual int GetBarBegin()  const=0;
			virtual int GetBarLength() const=0;
		protected:
			int GetMeter() const { return m_pOwner->GetMeter(); }

		private:
			IGUISlider*	m_pOwner;
		};

	public:
		IGUISlider();

		void	SetListener(const boost::shared_ptr<Listener>& pListener );
		const boost::shared_ptr<Listener>&	GetSliderListener() const;

		void	SetMeterRange( int begin, int len );
		void	SetMeter( int pos );
		void	SetMeterCallMessage( int pos );
		int		GetMeter() const;

	protected:

		virtual void OnLocalCharCode( const mstring& CharCode ){};
		virtual void OnLocalChangeState( bool NewStateEnable, bool NewStateVisible ){};
		virtual void OnLocalFocusIn();
		virtual void OnLocalFocusOut();

	protected:
		int	GetButtonPos() const;
		int	CalcMeter( int pos ) const;

	protected:
		boost::shared_ptr<Listener>	m_pListener;


		int		m_MeterBegin;	//!<	̊Jn̒l
		int		m_MeterLength;	//!<	̒
		int		m_NowMeter;		//!<	݂̈ʒu

		int		m_BarBegin;		//!<	o[̔zuW
		int		m_BarLength;	//!<	o[̒


		enum STATE
		{
			STATE_NORMAL,	//!<	ʏ
			STATE_MOVE,		//!<	}EXŃXC_𓮂
		};

		STATE	m_State;
	};
	typedef boost::shared_ptr<IGUISlider::Listener> SPGUISLIDERLISTENER;


	//	cXC_̃C^tF[X
	class CGUISliderVH : public IGUISlider
	{
	public:
		enum TYPE
		{
			TYPE_V,	//	cXC_
			TYPE_H,	//	XC_
		};

		void SetSliderType( TYPE type );

	protected:
		virtual bool IsLocalCollision( const POINT2DI& pos ) const;
		virtual void OnLocalMove();
		virtual void OnLocalDraw( const POINT2DI& pos, CGraphic& Render );
		virtual void OnLocalMouseIn  ( const POINT2DI& pos );
		virtual void OnLocalMouseOut ( const POINT2DI& pos );
		virtual void OnLocalMouseDown( const POINT2DI& pos );
		virtual void OnLocalMouseUp  ( const POINT2DI& pos );
		virtual void OnLocalMouseMove( const POINT2DI& pos );
		virtual void OnLocalKeyDown( unt08 KeyCode );
		virtual void OnLocalKeyUp( unt08 KeyCode ){}

	private:
		VECTOR2DI GetButtonOffset() const;
		int		 CalcMeter( const POINT2DI& pos )const;
	private:
		TYPE	m_Type;
	};



}

#endif