#include"CGUITextBox.h"
#include"CGUIManager.h"
#include"../../Auxiliary/CString.h"

namespace Maid
{
	/*!
	 *	\class	CGUITextBox CGUITextBox.h
	 *	\brief	eLXg{bNXNX
	 */


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!
 *
 */
CGUITextBox::CGUITextBox()
{
	m_CursorPos = 0;
	m_TextLengthByte= 30;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! eLXg{bNXXi̐ݒ
/*!
 *	ݓ͂ĂeLXg\ɂ郊Xi
 *	edoŕҏW̃eLXg FepListener ̎dł
 *
 *	\param	pListener	[i ]	ݒ肷郊Xi
 */
void CGUITextBox::SetListener( const boost::shared_ptr<Listener>& pListener )
{
	m_pListener = pListener;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! VeLXg̐ݒ
/*!
 *	\param	text	[i ]	ݒ肷eLXg
 */
void CGUITextBox::SetText( const mstring& text )
{
	m_InputText = text;
	m_CursorPos = 0;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ݓ͂ĂeLXg̐ݒ
/*!
 *	\param	text	[i ]	ݒ肷eLXg
 */
const mstring& CGUITextBox::GetText() const
{
	return m_InputText;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ݓ͂ł镶̒̐ݒ
/*!
 *	\param	Length	[i ]	ݒ肷钷ibyteP)
 */
void CGUITextBox::SetTextLengthByte( unt32 Length )
{
	m_TextLengthByte = Length;
	ClipText();
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t[̏
/*!
 *	Ȃǂ IGUIParts::OnLocalMove QƂ邱
 */
void CGUITextBox::OnLocalMove()
{
	if( m_pListener.get()!=NULL ) { m_pListener->OnMove(); }
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t[̕`
/*!
 *	Ȃǂ IGUIParts::OnLocalDraw QƂ邱
 */
void CGUITextBox::OnLocalDraw( const POINT2DI& pos, CGraphic& Render )
{
	if( m_pListener.get()!=NULL )
	{
		Listener::EDITINFO Info;

		Info.Text = m_InputText;
		Info.Cursor = m_CursorPos;
		Info.pIME = GetOwner()->GetIME();

		m_pListener->OnDraw( pos, Render, Info ); 
	}
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ̃p[cɃJ[\邩H
/*!
 *	Ȃǂ IGUIParts::IsLocalCollision QƂ邱
 */
bool CGUITextBox::IsLocalCollision( const POINT2DI& pos ) const
{
	return m_pListener->IsCollision(pos);
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! }EX͈͓ɗɌĂ΂
/*!
 *	Ȃǂ IGUIParts::OnLocalMouseIn QƂ邱
 */
void CGUITextBox::OnLocalMouseIn  ( const POINT2DI& pos )
{
	MAID_ASSERT( m_pListener.get()==NULL, "Xi̐ݒ肪Ă܂" );
	return m_pListener->OnMouseIn();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! }EX͈͓痣ꂽɌĂ΂
/*!
 *	Ȃǂ IGUIParts::OnLocalMouseOut QƂ邱
 */
void CGUITextBox::OnLocalMouseOut ( const POINT2DI& pos )
{
	MAID_ASSERT( m_pListener.get()==NULL, "Xi̐ݒ肪Ă܂" );
	return m_pListener->OnMouseOut();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! }EX̃{^ꂽɌĂ΂
/*!
 *	Ȃǂ IGUIParts::OnLocalMouseDown QƂ邱
 */
void CGUITextBox::OnLocalMouseDown( const POINT2DI& pos )
{
	//	J[\ʒüړƂׂ낤
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! }EX̃{^ꂽɌĂ΂
/*!
 *	Ȃǂ IGUIParts::OnLocalMouseUp QƂ邱
 */
void CGUITextBox::OnLocalMouseUp  ( const POINT2DI& pos )
{
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! }EX̃J[\ɌĂ΂
/*!
 *	Ȃǂ IGUIParts::OnLocalMouseMove QƂ邱
 */
void CGUITextBox::OnLocalMouseMove( const POINT2DI& pos )
{
	//	͈͑IƂƂƎv
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! L[{[h̃L[ꂽɌĂ΂
/*!
 *	Ȃǂ IGUIParts::OnLocalKeyDown QƂ邱
 */
void CGUITextBox::OnLocalKeyDown( unt08 KeyCode )
{
	//	L[{[h̑̂ƂɃJ[\vZ
	switch( KeyCode )
	{
	case CKeybord::BUTTON_LEFT: 
		{
			m_CursorPos = max( 0, m_CursorPos-1 );
		}break;

	case CKeybord::BUTTON_RIGHT:
		{
			int32 NewPos = min( int32(m_InputText.length()), m_CursorPos+1 );
			m_CursorPos = NewPos;
		}break;

	case CKeybord::BUTTON_DELETE:
		{
			if( !(m_CursorPos<(int)m_InputText.length()) ) { break; }
			m_InputText.erase( m_CursorPos, 1 );
			CallBack(GUIMESSAGE_TEXTBOX_CHANGETEXT);
		}break;
	}

}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! R[h͂ꂽɌĂ΂
/*!
 *	Ȃǂ IGUIParts::OnLocalCharCode QƂ邱
 */
void CGUITextBox::OnLocalCharCode( const mstring& CharCode )
{
	if( CharCode.length()==1 )
	{
		switch(CharCode[0])
		{
		case '\b':
			{
				//	obNXy[X
				const int32 DelPos = m_CursorPos-1;

				if( DelPos<0 ) { return ; }

				m_InputText.erase( DelPos, 1 );
				m_CursorPos -= 1;
				CallBack(GUIMESSAGE_TEXTBOX_CHANGETEXT);
			}break;

		case '\t':
		case '\n':
		case '\r':
		case 0x1b: { }break;

		default:
			{
				m_InputText.insert( m_CursorPos, CharCode );
				m_CursorPos += (int)CharCode.length();
				CallBack(GUIMESSAGE_TEXTBOX_CHANGETEXT);
			}break;
		}
	}else
	{
		m_InputText.insert( m_CursorPos, CharCode );
		m_CursorPos += (int)CharCode.length();

		CallBack(GUIMESSAGE_TEXTBOX_CHANGETEXT);
	}

	ClipTextNoCallBack();
}



/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! tH[JXƂɌĂ΂
/*!
 *	Ȃǂ IGUIParts::OnLocalFocusIn QƂ邱
 */
void CGUITextBox::OnLocalFocusIn()
{
	MAID_ASSERT( m_pListener.get()==NULL, "Xi̐ݒ肪Ă܂" );
	m_pListener->OnFocusIn();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! tH[JXƂɌĂ΂
/*!
 *	Ȃǂ IGUIParts::OnLocalFocusOut QƂ邱
 */
void CGUITextBox::OnLocalFocusOut()
{
	MAID_ASSERT( m_pListener.get()==NULL, "Xi̐ݒ肪Ă܂" );
	m_pListener->OnFocusOut();
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ݒ肳Ă镶̒ɃNbsOB
/*!
 */
void	CGUITextBox::ClipText()
{
	if( CString::CountByte(m_InputText) <= (int)m_TextLengthByte ) { return ; }

	ClipTextNoCallBack();

	CallBack(GUIMESSAGE_TEXTBOX_CHANGETEXT);
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ݒ肳Ă镶̒ɃNbsOBR[obN͂Ȃ
/*!
 */
void	CGUITextBox::ClipTextNoCallBack()
{
	if( CString::CountByte(m_InputText) <= (int)m_TextLengthByte ) { return ; }

	{
		int byte=0;
		for( int i=0; i<(int)m_InputText.length(); ++i )
		{
			if( CString::IsHankaku(m_InputText[i]) )	{ byte += 1; }
			else							{ byte += 2; }
			if( (int)m_TextLengthByte < byte )
			{
				m_InputText.resize(i);
				break;
			}
		}
	}
/*
	m_InputText.resize(m_TextLength);
*/

	m_CursorPos = min(int(m_CursorPos),int(m_InputText.length()));
}


}
