/*!
 *	\file
 *	\brief	fthp[ceLXg{bNXNX
 *
 */
#ifndef CGUITextBox_h
#define CGUITextBox_h

#include"CGUIParts.h"
#include"../../Input/CInputMethod.h"

namespace Maid
{

	class CGUITextBox : public IGUIParts
	{
	public:
		class Listener
		{
			friend CGUITextBox;
		public:
			virtual ~Listener(){}
			virtual bool IsCollision( const POINT2DI& pos )const{return false;}//!<	͈͓ɃJ[\邩
			virtual void OnMove(){}

			struct EDITINFO
			{
				mstring Text;
				unt32 Cursor;
				const CInputMethod* pIME;
			};

			virtual void OnDraw( const POINT2DI& pos, CGraphic& Render, const EDITINFO& Info ){}
			virtual void OnMouseIn (){}
			virtual void OnMouseOut(){}
			virtual void OnFocusIn(){}
			virtual void OnFocusOut(){}
		};

	public:
		CGUITextBox();
		void	SetListener( const boost::shared_ptr<Listener>& pListener );
		const boost::shared_ptr<Listener>&	GetListener() const { return m_pListener; }

		void SetText( const mstring& text );
		const mstring& GetText() const;

		void SetTextLengthByte( unt32 Length );

	protected:
		virtual void OnLocalMove();
		virtual void OnLocalDraw( const POINT2DI& pos, CGraphic& Render );
		virtual bool IsLocalCollision( const POINT2DI& pos ) const;

		virtual void OnLocalMouseIn  ( const POINT2DI& pos );
		virtual void OnLocalMouseOut ( const POINT2DI& pos );
		virtual void OnLocalMouseDown( const POINT2DI& pos );
		virtual void OnLocalMouseUp  ( const POINT2DI& pos );
		virtual void OnLocalMouseMove( const POINT2DI& pos );
		virtual void OnLocalKeyDown( unt08 KeyCode );
		virtual void OnLocalKeyUp( unt08 KeyCode ){};
		virtual void OnLocalCharCode( const mstring& CharCode );
		virtual void OnLocalChangeState( bool NewStateEnable, bool NewStateVisible ){};
		virtual void OnLocalFocusIn ();
		virtual void OnLocalFocusOut();

	private:
		void	ClipText();
		void	ClipTextNoCallBack();

	private:
		boost::shared_ptr<Listener>		m_pListener;

		mstring		m_InputText;
		int32				m_CursorPos;
		unt32				m_TextLengthByte;
	};

	typedef boost::shared_ptr<CGUITextBox::Listener> SPGUITEXTBOXLISTENER;
}

#endif