/*!
 	@file
 	@brief Windowspt[[Nx[XNX
 */

#ifndef CApplicationWindows_h
#define CApplicationWindows_h

#include"../../Setup/CompileMode.h"
#include"../../Setup/Win32.h"
#include"../../auxiliary/mstring.h"
#include"../CApplication.h"
#include"CMessageHookManager.h"
#include<vector>

namespace Maid
{
	class IApplicationWindows : public IApplication
	{
	public:
		IApplicationWindows();
		virtual ~IApplicationWindows();

		virtual bool IsValid();
		virtual void ApplicationExit();

		int Run( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow );

		HINSTANCE		GetHINSTANCE()	const;
		const mstring	GetClassName()	const;
		const LPSTR		GetCmdLineALL()	const;
		const MySTL::vector<mstring>&	GetCmdLine()const;
		mstring	GetCmdLine( int no )const;


		static IApplicationWindows* GetInstance();

	protected:
		virtual void OnSetup()=0;
		virtual void OnLoop()=0;
		virtual void OnCleanup()=0;


	private:
		static LRESULT CALLBACK ProcessProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam );

		HINSTANCE	m_Instance;
		HINSTANCE	m_PrevInstance;
		LPSTR		m_pCmdLine;
		int			m_CmdShow;

		MySTL::vector<mstring>	m_DivComdList;	//	ꂽR}hC

		CMessageHookManager	m_HookManager;

		int	m_ApplicationExitCode;
	};
}
#endif
