/*!
 	@file
 	@brief EBhENX
 */


#ifndef CWindow_h
#define CWindow_h

#include"../../Setup/CompileMode.h"
#include"../../Setup/Win32.h"
#include"../../Auxiliary/Macro.h"
#include"../../Auxiliary/mstring.h"
#include"../../template/Mathematics/Point.h"
#include"../../template/Mathematics/Size.h"

#include"CMessageHook.h"
#include<boost/function.hpp>
#include<boost/bind.hpp>
#include<map>

namespace Maid
{ 
	class CWindow : public IMessageHook
	{
	public:
		enum CALLBACKCODE
		{
			CALLBACKCODE_EXIT=0,
			CALLBACKCODE_CONTINUE,
		};
		typedef boost::function1<CALLBACKCODE, CWindowsMessage& >	MESSAGEFUNCTION;

		enum WINDOWSTYLE
		{
			WINDOWSTYLE_NORMAL,		//!<	^Cgo[AVXe{bNXATCYύXst[t
			WINDOWSTYLE_OVERLAP,	//!<	^Cgo[AVXe{bNXATCYύXt[t
			WINDOWSTYLE_POPUP,		//!<	ʂitXN[j
			WINDOWSTYLE_CONSOLE,	//!<	R\[iOj
		};

	public:
		CWindow();
		virtual ~CWindow();

		void RegistCallBack( UINT Msg, const MESSAGEFUNCTION& Function );
		void DeleteCallBack( UINT Msg );

		void Show();
		void Hide();

		void SetPosition( const POINT2DI& pos );
		void SetSize( const SIZE2DI& pos );
		void SetStyle( WINDOWSTYLE Style );
		void SetDragDropMode( bool IsAccept );
		void SetCaption( const mstring& Name );


		HWND GetHWND();
		SIZE2DI GetSize();


		void Create();
		void Destory();


		virtual IMessageHook::RETURNCODE OnMessage( CWindowsMessage& Param );

	private:
		DWORD	_GetWindowStyle( WINDOWSTYLE Style );

	private:
		mstring		m_Caption;	//!<	EBhELvV
		POINT2DI	m_Pos;		//!<	EBhĚݍW
		SIZE2DI		m_Size;		//!<	NCAg̈̑傫
		WINDOWSTYLE	m_Style;

		HWND	m_hWnd;		//!< m_hWnd==NULL ܂EBhEĂȂ

		bool	m_IsDandD;	//!<	Drag&Drop 邩H
		bool	m_IsShow;	//!<	\H
		MySTL::map<UINT,MESSAGEFUNCTION>	m_MessageMap;	//!<	bZ[W}bv

	};

	//!	ȗIȏ
	#define MakeCallBackObject(pFunc,pObject) boost::bind( pFunc, pObject, _1 )



}

#endif
