#include"CGraphic.h"

#include"CRenderMessageImpl1.h"
#include"CRenderMessageImpl3.h"

//	̃\[Xɂ 荞݃bZ[W


namespace Maid
{
	using namespace RenderMessage;

void CGraphic::SendVideoInfo()
{
	boost::shared_ptr<RenderMessage::GetVideoInfo> pMess( new RenderMessage::GetVideoInfo );

	PostRenderMessage( pMess, true );
}


mstring CGraphic::GetVideoInfo()
{
	CThreadMutexLocker Lock(m_ReturnDateMutex);
	return m_VideoInfo;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! 𑜓x̕ύX
/*!
 	@param	Mode		[i ]	XN[[h
 */
void CGraphic::ChangeScreenMode( const SCREENMODE& Mode  )
{
	ScreenChange* pMess = new ScreenChange;

	switch( Mode.Mode )
	{
	case SCREENMODE::TYPE_FULL16: { pMess->Mode.Mode = IVideoCardDriver::SCREENMODE::TYPE_FULL16; }break;
	case SCREENMODE::TYPE_FULL32: { pMess->Mode.Mode = IVideoCardDriver::SCREENMODE::TYPE_FULL32; }break;
	case SCREENMODE::TYPE_WINDOW: { pMess->Mode.Mode = IVideoCardDriver::SCREENMODE::TYPE_WINDOW; }break;
	}

	
	pMess->Mode.Size = Mode.Size;
	pMess->Mode.RefreshRate = Mode.RefreshRate;
	pMess->Mode.IsSoftTnL = Mode.IsSoftTnL;
	pMess->Mode.IsWaitVSync = Mode.IsWaitVSync;
	pMess->Mode.IsAspectLock = Mode.IsAspectLock;

	PostRenderMessage( SPRENDERMESSAGE(pMess), true );

	m_ScreenMode = Mode;
}

void CGraphic::RegistSurface( const mstring& id, const SIZE2DI& size, PIXELFORMAT fmt )
{
	boost::shared_ptr<RenderMessage::RegistSurface> pMess( new RenderMessage::RegistSurface );

	pMess->ResistID = id;
	pMess->Size   = size;
	pMess->Format = fmt;

	PostRenderMessage( pMess, true );
}

void CGraphic::RegistTexture( const mstring& id, const boost::shared_ptr<CTextureBufferMemory>& pBuff )
{
	boost::shared_ptr<RenderMessage::RegistTexture> pMess( new RenderMessage::RegistTexture );

	pMess->ResistID = id;
	pMess->pTexture = pBuff;

	PostRenderMessage( pMess, true );
}

void CGraphic::RegistRTTexture( const mstring& id, const SIZE2DI& size, PIXELFORMAT fmt )
{
	boost::shared_ptr<RenderMessage::RegistRTTexture> pMess( new RenderMessage::RegistRTTexture );

	pMess->ResistID = id;
	pMess->Size   = size;
	pMess->Format = fmt;

	PostRenderMessage( pMess, true );
}


void CGraphic::RegistVertex( const mstring& id, const SPBINARY& pBuff, VERTEXFORMAT fmt )
{
	boost::shared_ptr<RenderMessage::RegistVertex> pMess( new RenderMessage::RegistVertex );

	pMess->ResistID = id;
	pMess->Format = fmt;
	pMess->pVertex = pBuff;

	PostRenderMessage( pMess, true );
}

void CGraphic::RegistIndex( const mstring& id, const SPBINARY& pBuff, int Stride )
{
	boost::shared_ptr<RenderMessage::RegistIndex> pMess( new RenderMessage::RegistIndex );

	pMess->ResistID = id;
	pMess->pIndex = pBuff;
	pMess->Stride = Stride;

	PostRenderMessage( pMess, true );
}


void CGraphic::RegistVertexShaderDefault( const mstring& id )
{
	boost::shared_ptr<RenderMessage::RegistVertexShader> pMess( new RenderMessage::RegistVertexShader );

	pMess->CodeType = RenderMessage::RegistVertexShader::TYPE_DEFAULT;
	pMess->ResistID = id;

	PostRenderMessage( pMess, true );
}

void CGraphic::RegistVertexShaderCustom( const mstring& id, const SPBINARY& pCode )
{
	boost::shared_ptr<RenderMessage::RegistVertexShader> pMess( new RenderMessage::RegistVertexShader );

	pMess->CodeType = RenderMessage::RegistVertexShader::TYPE_CUSTOM;
	pMess->ResistID = id;
	pMess->pCode = pCode;

	PostRenderMessage( pMess, true );
}


void CGraphic::RegistPixelShaderDefault( const mstring& id )
{
	boost::shared_ptr<RenderMessage::RegistPixelShader> pMess( new RenderMessage::RegistPixelShader );

	pMess->CodeType = RenderMessage::RegistPixelShader::TYPE_DEFAULT;
	pMess->ResistID = id;

	PostRenderMessage( pMess, true );
}

void CGraphic::RegistPixelShaderCustom( const mstring& id, const SPBINARY& pCode )
{
	boost::shared_ptr<RenderMessage::RegistPixelShader> pMess( new RenderMessage::RegistPixelShader );

	pMess->CodeType = RenderMessage::RegistPixelShader::TYPE_CUSTOM;
	pMess->ResistID = id;
	pMess->pCode = pCode;

	PostRenderMessage( pMess, true );
}

void CGraphic::RegistVertexDeclarationDefault( const mstring& id )
{
	boost::shared_ptr<RenderMessage::RegistVertexDeclaration> pMess( new RenderMessage::RegistVertexDeclaration );

	pMess->Type = RenderMessage::RegistVertexDeclaration::TYPE_DEFAULT;
	pMess->ResistID = id;
	PostRenderMessage( pMess, true );

}











void CGraphic::DeleteSurface( const mstring& id )
{
	boost::shared_ptr<RenderMessage::DeleteSurface> pMess( new RenderMessage::DeleteSurface );

	pMess->DeleteID = id;

	PostRenderMessage( pMess, true );
}


void CGraphic::DeleteTexture( const mstring& id )
{
	boost::shared_ptr<RenderMessage::DeleteTexture> pMess( new RenderMessage::DeleteTexture );

	pMess->DeleteID = id;

	PostRenderMessage( pMess, true );
}

void CGraphic::DeleteVertex( const mstring& id )
{
	boost::shared_ptr<RenderMessage::DeleteVertex> pMess( new RenderMessage::DeleteVertex );

	pMess->DeleteID = id;

	PostRenderMessage( pMess, true );
}

void CGraphic::DeleteIndex( const mstring& id )
{
	boost::shared_ptr<RenderMessage::DeleteIndex> pMess( new RenderMessage::DeleteIndex );

	pMess->DeleteID = id;

	PostRenderMessage( pMess, true );
}


void CGraphic::DeleteVertexShader( const mstring& id )
{
	boost::shared_ptr<RenderMessage::DeleteVertexShader> pMess( new RenderMessage::DeleteVertexShader );

	pMess->DeleteID = id;

	PostRenderMessage( pMess, true );
}

void CGraphic::DeletePixelShader( const mstring& id )
{
	boost::shared_ptr<RenderMessage::DeletePixelShader> pMess( new RenderMessage::DeletePixelShader );

	pMess->DeleteID = id;

	PostRenderMessage( pMess, true );
}

void CGraphic::DeleteVertexDeclaration( const mstring& id )
{
	boost::shared_ptr<RenderMessage::DeleteVertexDeclaration> pMess( new RenderMessage::DeleteVertexDeclaration );

	pMess->DeleteID = id;
	PostRenderMessage( pMess, true );

}



}