#include"CGraphic.h"

//	̃\[Xɂ 3DBLTn

static const float TexelClip = 0.5f;

namespace Maid
{

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Rcԏ̎w肵`PFœhԂ
/*!
 	SetBltState() Őݒ肵`惂[hōs܂
 
 	@param	Rect	[i ]	hԂ͈
 	@param	Scale	[i ]	gk 1.0 œ{
 	@param	Rotate	[i ]	]ʁiWAj
 	@param	vec		[i ]	]iKĂƁj
 	@param	Center	[i ]	ƂȂ(Rect.Left,Rect.Top)(0,0)ƂItZbg
 	@param	ColorLT	[i ]	`悷鍶̐F
 	@param	ColorRT	[i ]	`悷鍶̐F
 	@param	ColorLB	[i ]	`悷鍶̐F
 	@param	ColorRB	[i ]	`悷鍶̐F
 */
void CGraphic::Fill3DSR( const POINT3DF& Pos, const SIZE2DF& Size, const SIZE2DF& Scale, float Rotate, const VECTOR3DF& vec, const POINT3DF& Center, const COLOR_A08R08G08B08I& ColorLT, const COLOR_A08R08G08B08I& ColorRT, const COLOR_A08R08G08B08I& ColorLB, const COLOR_A08R08G08B08I& ColorRB )
{
	const MATRIX4DF wold = MATRIX4DF().SetScale( Scale.w, Scale.h, 0 )
						 * MATRIX4DF().SetRotationXYZ( Rotate, vec )
						 * MATRIX4DF().SetTranslate( Pos.x-TexelClip, Pos.y+TexelClip, Pos.z )
						 ;

	Fill3D( wold, Size, Center, ColorLT, ColorRT, ColorLB, ColorRB );
}



void CGraphic::Fill3D( const MATRIX4DF& mat, const SIZE2DF& Size, const POINT3DF& Center, const COLOR_A08R08G08B08I& ColorLT, const COLOR_A08R08G08B08I& ColorRT, const COLOR_A08R08G08B08I& ColorLB, const COLOR_A08R08G08B08I& ColorRB )
{
	const float l =  - Center.x;
	const float r =  Size.w - Center.x;
	const float t =  -Center.y;
	const float b =  Size.h - Center.y;
	const float z =  -Center.z;


	const CUSTOMVERTEX_3DCOLOR	Sprite[] =
	{
		CUSTOMVERTEX_3DCOLOR(POINT3DF(l, -t, z), ColorLT ),
		CUSTOMVERTEX_3DCOLOR(POINT3DF(r, -t, z), ColorRT ),
		CUSTOMVERTEX_3DCOLOR(POINT3DF(l, -b, z), ColorLB ),
		CUSTOMVERTEX_3DCOLOR(POINT3DF(r, -b, z), ColorRB ),
	};

	SetRenderStateZWriteEnable(m_IsBlt3DZTest);
	SetRenderStateZTestEnable(m_IsBlt3DZTest);
	SetCullingMode(CULLINGMODE_NONE);

	const MATRIX4DF m = mat * m_CameraMatrix;

	m_VertexShaderBlt3D[0].SetConstantF( 0, m.GetTranspose() );

	UnsetAllTexture();
	SetVertexShader( m_VertexShaderBlt3D[0] );
	SetPixelShader( m_PixelShaderFill[m_BltState] );
	DrawPrimitiveUP( PRIMITIVE_TRIANGLESTRIP, Sprite, Sprite[0].GetStructSize(), 2 );

}



/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Rc``
/*!
 	ݒ肵JNX̐ݒ`悳܂
 
 	@param	Pos		[i ]	]W
 	@param	Src		[i ]	gpeNX`
 	@param	Rect	[i ]	g`
 	@param	Center	[i ]	ItZbg
 	@param	Alpha	[i ]	sx 0xFF ŊSɌiftHg0xFF)
 */
void CGraphic::Blt3D( const POINT3DF& Pos, const CTexture& Src, const RECT2DI& Rect, const POINT3DF& Center, unt08 Alpha )
{
	const MATRIX4DF trance = MATRIX4DF().SetTranslate( Pos.x-TexelClip, Pos.y+TexelClip, Pos.z );

	const COLOR_A08R08G08B08I Color(Alpha,0xFF,0xFF,0xFF);
	const MATRIX4DF m	= m_Blt3DParentMatrix
						* trance;

	Blt3D( m, Src, Rect, Center, Color, Color, Color, Color );
}




/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Rc`gk`
/*!
 	ݒ肵JNX̐ݒ`悳܂
 
 	@param	Pos		[i ]	]W
 	@param	Src		[i ]	gpeNX`
 	@param	Rect	[i ]	g`
 	@param	Scale	[i ]	gk
 	@param	Center	[i ]	ItZbg
 	@param	Alpha	[i ]	sx 0xFF ŊSɌiftHg0xFF)
 */
void CGraphic::Blt3DS( const POINT3DF& Pos, const CTexture& Src, const RECT2DI& Rect, const SIZE2DF& Scale, const POINT3DF& Center, unt08 Alpha )
{
	const MATRIX4DF trance = MATRIX4DF().SetTranslate( Pos.x-TexelClip, Pos.y+TexelClip, Pos.z );
	const MATRIX4DF scale  = MATRIX4DF().SetScale( Scale.w, Scale.h, 0.0f );
	
	const COLOR_A08R08G08B08I Color(Alpha,0xFF,0xFF,0xFF);
	const MATRIX4DF m	= m_Blt3DParentMatrix
						* scale * trance;


	Blt3D( m, Src, Rect, Center, Color, Color, Color, Color );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Rc`]`
/*!
 	ݒ肵JNX̐ݒ`悳܂
 
 	@param	Pos		[i ]	]W
 	@param	Src		[i ]	gpeNX`
 	@param	Rect	[i ]	g`
 	@param	Rotate	[i ]	]
 	@param	vec		[i ]	]
 	@param	Center	[i ]	ItZbg
 	@param	Alpha	[i ]	sx 0xFF ŊSɌiftHg0xFF)
 */
void CGraphic::Blt3DR ( const POINT3DF& Pos, const CTexture& Src, const RECT2DI& Rect, float Rotate, const VECTOR3DF& vec, const POINT3DF& Center, unt08 Alpha )
{
	const MATRIX4DF trance = MATRIX4DF().SetTranslate( Pos.x-TexelClip, Pos.y+TexelClip, Pos.z );
	const MATRIX4DF rot    = MATRIX4DF().SetRotationXYZ( Rotate, vec );
	
	const COLOR_A08R08G08B08I Color(Alpha,0xFF,0xFF,0xFF);
	const MATRIX4DF m	= m_Blt3DParentMatrix
						* rot * trance;


	Blt3D( m, Src, Rect, Center, Color, Color, Color, Color );
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Rc`]gk`
/*!
 	ݒ肵JNX̐ݒŕ`悳܂
 
 	@param	Pos		[i ]	]W
 	@param	Src		[i ]	gpeNX`
 	@param	Rect	[i ]	g`
 	@param	Scale	[i ]	gk
 	@param	Rotate	[i ]	]
 	@param	vec		[i ]	]
 	@param	Center	[i ]	ItZbg
 	@param	Alpha	[i ]	sx 0xFF ŊSɌiftHg0xFF)
 */
void CGraphic::Blt3DSR( const POINT3DF& Pos, const CTexture& Src, const RECT2DI& Rect, const SIZE2DF& Scale, float Rotate, const VECTOR3DF& vec, const POINT3DF& Center, unt08 Alpha )
{
	const MATRIX4DF trance = MATRIX4DF().SetTranslate( Pos.x-TexelClip, Pos.y+TexelClip, Pos.z );
	const MATRIX4DF rot    = MATRIX4DF().SetRotationXYZ( Rotate, vec );
	const MATRIX4DF scale  = MATRIX4DF().SetScale( Scale.w, Scale.h, 0.0f );

	const COLOR_A08R08G08B08I Color(Alpha,0xFF,0xFF,0xFF);
	const MATRIX4DF m	= m_Blt3DParentMatrix
						* scale * rot * trance;


	Blt3D( m, Src, Rect, Center, Color, Color, Color, Color );
}

#if 0

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Rc`]gk`
/*!
 	ݒ肵JNX̐ݒŕ`悳܂
 
 	@param	Pos		[i ]	]W
 	@param	Src		[i ]	gpeNX`
 	@param	Rect	[i ]	g`
 	@param	Rotate	[i ]	](w)
 	@param	Rotate	[i ]	](x)
 	@param	Rotate	[i ]	](y)
 	@param	Center	[i ]	ItZbg
 	@param	Alpha	[i ]	sx 0xFF ŊSɌiftHg0xFF)
 */
void CGraphic::Blt3DR ( const POINT3DF& Pos, const CTexture& Src, const RECT2DI& Rect, float RotateX, float RotateY, float RotateZ, const POINT3DF& Center, unt08 Alpha )
{
	const COLOR_A08R08G08B08I Color(Alpha,0xFF,0xFF,0xFF);
	const MATRIXPOSITION pos = MATRIXPOSITION_WORLD0;

	SetMatrix( pos, MATRIX4DF().SetTranslate( Pos.x-TexelClip, Pos.y+TexelClip, Pos.z ) );
	MulMatrix( pos, MATRIX4DF().SetRotationX( RotateX ) );
	MulMatrix( pos, MATRIX4DF().SetRotationY( RotateY ) );
	MulMatrix( pos, MATRIX4DF().SetRotationZ( RotateZ ) );
	MulMatrix( pos, m_Blt3DParentMatrix );

	Blt3D( Src, Rect, Center, Color, Color, Color, Color );
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Rc`]gk`
/*!
 	ݒ肵JNX̐ݒŕ`悳܂
 
 	@param	Pos		[i ]	]W
 	@param	Src		[i ]	gpeNX`
 	@param	Rect	[i ]	g`
 	@param	Scale	[i ]	gk
 	@param	Rotate	[i ]	](w)
 	@param	Rotate	[i ]	](x)
 	@param	Rotate	[i ]	](y)
 	@param	Center	[i ]	ItZbg
 	@param	Alpha	[i ]	sx 0xFF ŊSɌiftHg0xFF)
 */
void CGraphic::Blt3DSR( const POINT3DF& Pos, const CTexture& Src, const RECT2DI& Rect, const SIZE2DF& Scale, float RotateX, float RotateY, float RotateZ, const POINT3DF& Center, unt08 Alpha )
{
	const COLOR_A08R08G08B08I Color(Alpha,0xFF,0xFF,0xFF);
	const MATRIXPOSITION pos = MATRIXPOSITION_WORLD0;

	SetMatrix( pos, MATRIX4DF().SetTranslate( Pos.x-TexelClip, Pos.y+TexelClip, Pos.z ) );
	MulMatrix( pos, MATRIX4DF().SetRotationX( RotateX ) );
	MulMatrix( pos, MATRIX4DF().SetRotationY( RotateY ) );
	MulMatrix( pos, MATRIX4DF().SetRotationZ( RotateZ ) );
	MulMatrix( pos, MATRIX4DF().SetScale( Scale.w, Scale.h, 0.0f ) );
	MulMatrix( pos, m_Blt3DParentMatrix );



	Blt3D( Src, Rect, Center, Color, Color, Color, Color );
}


void CGraphic::Blt3DSXYZ( const POINT3DF& Pos, const CTexture& Src, const RECT2DI& Rect, const SIZE2DF& Scale, float RotateX, float RotateY, float RotateZ, const POINT3DF& Center, unt08 Alpha )
{
	const COLOR_A08R08G08B08I Color(Alpha,0xFF,0xFF,0xFF);
	const MATRIXPOSITION pos = MATRIXPOSITION_WORLD0;

	SetMatrix( pos, MATRIX4DF().SetTranslate( Pos.x-TexelClip, Pos.y+TexelClip, Pos.z ) );
	MulMatrix( pos, MATRIX4DF().SetRotationX( RotateX ) );
	MulMatrix( pos, MATRIX4DF().SetRotationY( RotateY ) );
	MulMatrix( pos, MATRIX4DF().SetRotationZ( RotateZ ) );
	MulMatrix( pos, MATRIX4DF().SetScale( Scale.w, Scale.h, 0.0f ) );
	MulMatrix( pos, m_Blt3DParentMatrix );


	Blt3D( Src, Rect, Center, Color, Color, Color, Color );
}


void CGraphic::Blt3DSXZY( const POINT3DF& Pos, const CTexture& Src, const RECT2DI& Rect, const SIZE2DF& Scale, float RotateX, float RotateZ, float RotateY, const POINT3DF& Center, unt08 Alpha )
{
	const COLOR_A08R08G08B08I Color(Alpha,0xFF,0xFF,0xFF);
	const MATRIXPOSITION pos = MATRIXPOSITION_WORLD0;

	SetMatrix( pos, MATRIX4DF().SetTranslate( Pos.x-TexelClip, Pos.y+TexelClip, Pos.z ) );
	MulMatrix( pos, MATRIX4DF().SetRotationX( RotateX ) );
	MulMatrix( pos, MATRIX4DF().SetRotationZ( RotateZ ) );
	MulMatrix( pos, MATRIX4DF().SetRotationY( RotateY ) );
	MulMatrix( pos, MATRIX4DF().SetScale( Scale.w, Scale.h, 0.0f ) );
	MulMatrix( pos, m_Blt3DParentMatrix );


	Blt3D( Src, Rect, Center, Color, Color, Color, Color );
}



void CGraphic::Blt3DSYXZ( const POINT3DF& Pos, const CTexture& Src, const RECT2DI& Rect, const SIZE2DF& Scale, float RotateY, float RotateX, float RotateZ, const POINT3DF& Center, unt08 Alpha )
{
	const COLOR_A08R08G08B08I Color(Alpha,0xFF,0xFF,0xFF);
	const MATRIXPOSITION pos = MATRIXPOSITION_WORLD0;

	SetMatrix( pos, MATRIX4DF().SetTranslate( Pos.x-TexelClip, Pos.y+TexelClip, Pos.z ) );
	MulMatrix( pos, MATRIX4DF().SetRotationY( RotateY ) );
	MulMatrix( pos, MATRIX4DF().SetRotationX( RotateX ) );
	MulMatrix( pos, MATRIX4DF().SetRotationZ( RotateZ ) );
	MulMatrix( pos, MATRIX4DF().SetScale( Scale.w, Scale.h, 0.0f ) );
	MulMatrix( pos, m_Blt3DParentMatrix );

	Blt3D( Src, Rect, Center, Color, Color, Color, Color );
}


void CGraphic::Blt3DSYZX( const POINT3DF& Pos, const CTexture& Src, const RECT2DI& Rect, const SIZE2DF& Scale, float RotateY, float RotateZ, float RotateX, const POINT3DF& Center, unt08 Alpha )
{
	const COLOR_A08R08G08B08I Color(Alpha,0xFF,0xFF,0xFF);
	const MATRIXPOSITION pos = MATRIXPOSITION_WORLD0;

	SetMatrix( pos, MATRIX4DF().SetTranslate( Pos.x-TexelClip, Pos.y+TexelClip, Pos.z ) );
	MulMatrix( pos, MATRIX4DF().SetRotationY( RotateY ) );
	MulMatrix( pos, MATRIX4DF().SetRotationZ( RotateZ ) );
	MulMatrix( pos, MATRIX4DF().SetRotationX( RotateX ) );
	MulMatrix( pos, MATRIX4DF().SetScale( Scale.w, Scale.h, 0.0f ) );
	MulMatrix( pos, m_Blt3DParentMatrix );

	Blt3D( Src, Rect, Center, Color, Color, Color, Color );
}


void CGraphic::Blt3DSZXY( const POINT3DF& Pos, const CTexture& Src, const RECT2DI& Rect, const SIZE2DF& Scale, float RotateZ, float RotateX, float RotateY, const POINT3DF& Center, unt08 Alpha )
{
	const COLOR_A08R08G08B08I Color(Alpha,0xFF,0xFF,0xFF);
/*
	const MATRIXPOSITION pos = MATRIXPOSITION_WORLD0;

	SetMatrix( pos, MATRIX4DF().SetTranslate( Pos.x-TexelClip, Pos.y+TexelClip, Pos.z ) );
	MulMatrix( pos, MATRIX4DF().SetRotationZ( RotateZ ) );
	MulMatrix( pos, MATRIX4DF().SetRotationX( RotateX ) );
	MulMatrix( pos, MATRIX4DF().SetRotationY( RotateY ) );
	MulMatrix( pos, MATRIX4DF().SetScale( Scale.w, Scale.h, 0.0f ) );
	MulMatrix( pos, m_Blt3DParentMatrix );
*/
	MATRIX4DF m = m_Blt3DParentMatrix
				* MATRIX4DF().SetScale( Scale.w, Scale.h, 0.0f )
				* MATRIX4DF().SetRotationY( RotateX )
				* MATRIX4DF().SetRotationX( RotateY )
				* MATRIX4DF().SetRotationZ( RotateZ )
				* MATRIX4DF().SetTranslate( Pos.x-TexelClip, Pos.y+TexelClip, Pos.z );

	Blt3D( m, Src, Rect, Center, Color, Color, Color, Color );
}


void CGraphic::Blt3DSZYX( const POINT3DF& Pos, const CTexture& Src, const RECT2DI& Rect, const SIZE2DF& Scale, float RotateZ, float RotateY, float RotateX, const POINT3DF& Center, unt08 Alpha )
{
	const COLOR_A08R08G08B08I Color(Alpha,0xFF,0xFF,0xFF);
/*
	const MATRIXPOSITION pos = MATRIXPOSITION_WORLD0;

	SetMatrix( pos, MATRIX4DF().SetTranslate( Pos.x-TexelClip, Pos.y+TexelClip, Pos.z ) );
	MulMatrix( pos, MATRIX4DF().SetRotationZ( RotateZ ) );
	MulMatrix( pos, MATRIX4DF().SetRotationY( RotateY ) );
	MulMatrix( pos, MATRIX4DF().SetRotationX( RotateX ) );
	MulMatrix( pos, MATRIX4DF().SetScale( Scale.w, Scale.h, 0.0f ) );
	MulMatrix( pos, m_Blt3DParentMatrix );
*/

	MATRIX4DF m = m_Blt3DParentMatrix
				* MATRIX4DF().SetScale( Scale.w, Scale.h, 0.0f )
				* MATRIX4DF().SetRotationX( RotateX )
				* MATRIX4DF().SetRotationY( RotateY )
				* MATRIX4DF().SetRotationZ( RotateZ )
				* MATRIX4DF().SetTranslate( Pos.x-TexelClip, Pos.y+TexelClip, Pos.z );

	Blt3D( m, Src, Rect, Center, Color, Color, Color, Color );
}

#endif

void CGraphic::Blt3D  ( const MATRIX4DF& mat, const CTexture& Src, const RECT2DI& Rect, const POINT3DF& Center, unt08 Alpha )
{
	const COLOR_A08R08G08B08I Color(Alpha,0xFF,0xFF,0xFF);
	Blt3D( mat, Src, Rect, Center, Color, Color, Color, Color );
}








/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! |S`悷
/*!	
 	Blt3D ֌Ŵ܂Ƃߊ֐ł
 	łɍs͐ݒ肳Ă̂Ƃ܂
 
 	@param	Src		[i ]	gpeNX`
 	@param	Rect	[i ]	g`
 	@param	Center	[i ]	ItZbg
 	@param	ColorLT	[i ]	̒_J[
 	@param	ColorRT	[i ]	E̒_J[
 	@param	ColorLD	[i ]	̒_J[
 	@param	ColorRD	[i ]	E̒_J[
 */
void CGraphic::Blt3D  ( const MATRIX4DF& mat, const CTexture& Src, const RECT2DI& Rect, const POINT3DF& Center, const COLOR_A08R08G08B08I& ColorLT, const COLOR_A08R08G08B08I& ColorRT, const COLOR_A08R08G08B08I& ColorLD, const COLOR_A08R08G08B08I& ColorRD  )
{
	const float Width  = (float)Rect.w;
	const float Height = (float)Rect.h; 

	const float vLeft  = 0.0f - Center.x;//-TexelClip;
	const float vTop   = 0.0f - Center.y;//-TexelClip;
	const float vRight = vLeft + Width;
	const float vBottom= vTop  + Height;
	const float vDepth = -Center.z;

	const SIZE2DI texsize = Src.GetTextureSize();

	const float tLeft  = (float)Rect.x  /(float)texsize.w;
	const float tTop   = (float)Rect.y  /(float)texsize.h;
	const float tRight = (float)Rect.GetRight() /(float)texsize.w;
	const float tBottom= (float)Rect.GetBottom()/(float)texsize.h;

	const CUSTOMVERTEX_3DSPRITE	Sprite[] =
	{
		CUSTOMVERTEX_3DSPRITE(POINT3DF(vLeft,  -vTop,	vDepth), ColorLT, POINT2DF(tLeft ,tTop   ) ),
		CUSTOMVERTEX_3DSPRITE(POINT3DF(vRight, -vTop,	vDepth), ColorRT, POINT2DF(tRight,tTop   ) ),
		CUSTOMVERTEX_3DSPRITE(POINT3DF(vLeft,  -vBottom, vDepth), ColorLD, POINT2DF(tLeft ,tBottom) ),
		CUSTOMVERTEX_3DSPRITE(POINT3DF(vRight, -vBottom, vDepth), ColorRD, POINT2DF(tRight,tBottom) ),
	};

	SetRenderStateZWriteEnable(m_IsBlt3DZTest);
	SetRenderStateZTestEnable(m_IsBlt3DZTest);
	SetCullingMode(CULLINGMODE_NONE);
	SetSamplerStateMagFilter( 0, m_FilterType );
	SetSamplerStateMinFilter( 0, m_FilterType );

	const MATRIX4DF m = mat * m_CameraMatrix;

	m_VertexShaderBlt3D[0].SetConstantF( 0, m.GetTranspose() );

	SetTexture( Src );
	SetVertexShader( m_VertexShaderBlt3D[0] );
	SetPixelShader( m_PixelShaderBlt[m_BltState] );
	DrawPrimitiveUP( PRIMITIVE_TRIANGLESTRIP, Sprite, Sprite[0].GetStructSize(), 2 );
}

}