/*!	
	@file
	@brief	荞ݖ߃bZ[W `
*/

#ifndef CRenderMessageImpl3_h
#define CRenderMessageImpl3_h

#include"../Setup/CompileMode.h"
#include"CRenderMessage.h"
#include"CCustomVertexTemplate.h"

#include"Core/Driver/CVideoCardDriver.h"
#include"Core/Driver/CTextureBufferMemory.h"


namespace Maid
{
	namespace RenderMessage
	{
		class ScreenChange : public Base
		{
		public:
			ScreenChange() : Base(SCREENCHANGE){}

			IVideoCardDriver::SCREENMODE Mode;
		};

		class RegistSurface : public Base
		{
		public:
			RegistSurface() : Base(REGISTSURFACE){}

			mstring		ResistID;	//!<	o^閼O
			SIZE2DI		Size;		//!<	T[tFX̑傫
			PIXELFORMAT	Format;		//!<	sNZtH[}bg
		};

		class RegistTexture : public Base
		{
		public:
			RegistTexture() : Base(REGISTTEXTURE){}

			mstring									ResistID;	//!<	o^閼O
			boost::shared_ptr<CTextureBufferMemory>	pTexture;	//!<	o^eNX`
		};

		class RegistRTTexture : public Base
		{
		public:
			RegistRTTexture() : Base(REGISTRTTEXTURE){}

			mstring		ResistID;	//!<	o^閼O
			SIZE2DI		Size;		//!<	eNX`̑傫
			PIXELFORMAT	Format;		//!<	sNZtH[}bg
		};

		class RegistVertex : public Base
		{
		public:
			RegistVertex() : Base(REGISTVERTEX){}

			mstring			ResistID;	//!<	o^閼O
			SPBINARY		pVertex;	//!<	o^f[^
			VERTEXFORMAT	Format;		//!<	tH[}bg
		};

		class RegistIndex : public Base
		{
		public:
			RegistIndex() : Base(REGISTINDEX){}

			mstring		ResistID;	//!<	o^閼O
			SPBINARY	pIndex;		//!<	o^f[^
			int			Stride;		//!<	PCfbNX̑傫
		};

		class RegistVertexShader : public Base
		{
		public:
			RegistVertexShader() : Base(REGISTVERTEXSHADER){}

			enum TYPE
			{
				TYPE_DEFAULT,
				TYPE_CUSTOM,
			};

			TYPE		CodeType;
			mstring		ResistID;	//!<	o^閼O
			SPBINARY	pCode;		//!<	o^R[h
		};

		class RegistVertexDeclaration : public Base
		{
		public:
			RegistVertexDeclaration() : Base(REGISTVERTEXDECLARATION){}

			enum TYPE
			{
				TYPE_DEFAULT,
				TYPE_CUSTOM,
			};

			TYPE		Type;
			mstring		ResistID;	//!<	o^閼O
			SPBINARY	pCode;		//!<	o^R[h
		};

		class RegistPixelShader : public Base
		{
		public:
			RegistPixelShader() : Base(REGISTPIXELSHADER){}

			enum TYPE
			{
				TYPE_DEFAULT,
				TYPE_CUSTOM,
			};

			TYPE		CodeType;
			mstring		ResistID;	//!<	o^閼O
			SPBINARY	pCode;		//!<	o^R[h
		};



		class DeleteSurface : public Base
		{
		public:
			DeleteSurface() : Base(DELETESURFACE){}

			mstring					DeleteID;	//!<	폜閼O
		};

		class DeleteTexture : public Base
		{
		public:
			DeleteTexture() : Base(DELETETEXTURE){}

			mstring					DeleteID;	//!<	폜閼O
		};

		class DeleteIndex : public Base
		{
		public:
			DeleteIndex() : Base(DELETEINDEX){}

			mstring					DeleteID;	//!<	폜閼O
		};

		class DeleteVertex : public Base
		{
		public:
			DeleteVertex() : Base(DELETEVERTEX){}

			mstring					DeleteID;	//!<	폜閼O
		};

		class DeleteVertexDeclaration : public Base
		{
		public:
			DeleteVertexDeclaration() : Base(DELETEVERTEXDECLARATION){}

			mstring					DeleteID;	//!<	폜閼O
		};

		class DeleteVertexShader : public Base
		{
		public:
			DeleteVertexShader() : Base(DELETEVERTEXSHADER){}

			mstring					DeleteID;	//!<	폜閼O
		};

		class DeletePixelShader : public Base
		{
		public:
			DeletePixelShader() : Base(DELETEPIXELSHADER){}

			mstring					DeleteID;	//!<	폜閼O
		};

	}


}


#endif
