/*!
 	@file
 	@brief	XvCgAj[VNX
 */

#ifndef CSprite_h
#define CSprite_h

#include"../Setup/CompileMode.h"


#include"CTextureFile.h"

#include<map>
#include<vector>

namespace Maid
{
	class CXMLNode;
	class CSpriteFile
	{
	public:
		struct ANIMATIONFRAME
		{
			unt	SpriteNo;
			unt	Frame;
		};

		typedef MySTL::vector<ANIMATIONFRAME> ANIMATION;

		struct SPRITEDATA
		{
			struct PARTS
			{
				POINT2DI DrawPos;
				int		 CellNo;
			};

			MySTL::vector<PARTS>	PartsList;
		};

		struct SPRITEFILE
		{
			CTextureFile				Texture;
			MySTL::vector<RECT2DI>		CellList;
			MySTL::vector<SPRITEDATA>	SpriteList;
			MySTL::vector<ANIMATION>	AnimationList;
		};

		typedef boost::shared_ptr<SPRITEFILE> SPSPRITEFILE;
		typedef MySTL::map<mstring,SPSPRITEFILE> CACHELIST;

		CSpriteFile();
		~CSpriteFile();

		void Load( const mstring& FileName );
		void Release();

		const CTextureFile&	GetTexture() const;
		const RECT2DI&		GetCell( int No ) const;
		const SPRITEDATA&	GetSprite( int No ) const;
		const ANIMATION&	GetAnimation( int No ) const;
		const MySTL::vector<RECT2DI>&	GetCellList() const;

		int	GetAnimationCount() const;
		bool IsLoad() const;

		bool IsNowLoading();

	private:
		void ReadFileName( const CXMLNode& node, mstring& FileName );
		void ReadCell( const CXMLNode& node, int& no, RECT2DI& rc );
		void ReadSprite( const CXMLNode& node, int& no, SPRITEDATA& sp );
		void ReadAnimation( const CXMLNode& node, int& no, ANIMATION& anim );

	private:
		static 	CACHELIST	s_CacheList;
		SPSPRITEFILE		m_pCacheData;
		mstring				m_FileName;
	};


	struct SPRITE
	{
		SPRITE( const CTextureFile& t, const MySTL::vector<RECT2DI>& c, const CSpriteFile::SPRITEDATA& s ):Texture(t),CellList(c),SpriteData(s){}
		const CTextureFile&				Texture;
		const MySTL::vector<RECT2DI>&	CellList;
		const CSpriteFile::SPRITEDATA&	SpriteData;
	};

	class CSprite
	{
	public:

		CSprite();
		virtual ~CSprite();
		void Load( const mstring& FileName );

		void CountInc();
		void CountDec();

		void JumpFrame( int Frame );

		void ChangePattern( int No );
		int GetPattern() const;
		void Release();

		SPRITE	GetNowSprite() const;

		bool IsEnd() const;

		void SetPlayState( bool IsPlay );
		bool IsPlay() const;
		bool IsLoad() const;

		bool IsNowLoading();
	private:
		CSpriteFile	m_Sprite;

		int		m_NowSprite;	//!<	ݕ\XvCgԍ
		int		m_ChangeCount;	//!<	Ɖt[Ő؂ւ邩H

		int		m_Pattern;		//!<	݂̍Đp^[ԍ
		int		m_Koma;			//!<	݂̃R}ԍ

		bool	m_IsPlay;		//!<	ĐH
	};


}
#endif
