#ifndef CSurfaceInfo_h
#define CSurfaceInfo_h

/*!
 	@file
 	@brief	ISurfaceInfo ̌pł悭gNXQ
 */


#include"../Setup/CompileMode.h"
#include"../Auxiliary/Debug/CAssert.h"


namespace Maid
{
	/*!
	 	@enum	PIXELFORMAT CSurface.h
	 	@brief	T[tFX̃sNZtH[}bg\enum
	 */
	enum PIXELFORMAT
	{
		PIXELFORMAT_NONE,	//!<	s@T̓G[


		PIXELFORMAT_COLORBEGIN,

		PIXELFORMAT_A08R08G08B08I,	//!<	At@L 32bit/Pixel
		PIXELFORMAT_X08R08G08B08I,	//!<	At@ 32bit/Pixel
		PIXELFORMAT_R08G08B08I,		//!<	At@ 24bit/Pixel
		PIXELFORMAT_A04R04G04B04I,	//!<	At@L 16bit/Pixel
		PIXELFORMAT_R05G06B05I,		//!<	At@ 16bit/Pixel
		PIXELFORMAT_X01R05G05B05I,	//!<	At@ 16bit/Pixel
		PIXELFORMAT_A01R05G05B05I,	//!<	J[LL 16bit/Pixel
		PIXELFORMAT_P08X08R08G08B08I,//!<	8bit/Pixel XRGB8888 pbgQƂŌ
		PIXELFORMAT_P08A08R08G08B08I,//!<	8bit/Pixel ARGB8888 pbgQƂŌ

		// J[tH[}bgꍇ͂ɒǉ
		//	 GetPixelBPP() ɂǉĂ
		//
		//	Maid Ŏgppbgׂ͂ 256 ł

		PIXELFORMAT_COLOREND,



		PIXELFORMAT_COMPLESSCOLORBEGIN,

		PIXELFORMAT_DXT1,	//!<	DirectX Texture Compression Format 1
		PIXELFORMAT_DXT2,	//!<	DirectX Texture Compression Format 2
		PIXELFORMAT_DXT3,	//!<	DirectX Texture Compression Format 3
		PIXELFORMAT_DXT4,	//!<	DirectX Texture Compression Format 4
		PIXELFORMAT_DXT5,	//!<	DirectX Texture Compression Format 5

		// kJ[tH[}bgꍇ͂ɒǉ
		//	 GetPixelBPP() ɂǉĂ

		PIXELFORMAT_COMPLESSCOLOREND,


		PIXELFORMAT_DEPTHSTENCILEBEGIN,

		PIXELFORMAT_D16,		//!<	16bit/Pixel  ZBuffer
		PIXELFORMAT_D32,		//!<	32bit/Pixel  ZBuffer
		PIXELFORMAT_D24X8,		//!<	32bit/Pixel (L͈24Bit)  ZBuffer
		PIXELFORMAT_D24S8,		//!<	32bit/Pixel ̂A 24Bit ZBuffer 8Bit ̃XeVobt@

		// [xtH[}bgꍇ͂ɒǉ
		//	 GetPixelBPP() ɂǉĂ

		PIXELFORMAT_DEPTHSTENCILEEND,

	};

	/*!
	 	@brief	sNZtH[}bgPsNZɎgp
	\n			rbg߂
	 
	 	@param	Format	[i ]	߂tH[}bg
	 
	 	@return	߂rbg
	 */
	inline int GetPixelBPP( PIXELFORMAT Format )
	{
		switch( Format )
		{
		case PIXELFORMAT_NONE:			{ return  0; }break;

		case PIXELFORMAT_A08R08G08B08I:		{ return 32; }break;
		case PIXELFORMAT_X08R08G08B08I:		{ return 32; }break;
		case PIXELFORMAT_R08G08B08I:		{ return 24; }break;
		case PIXELFORMAT_A04R04G04B04I:		{ return 16; }break;
		case PIXELFORMAT_R05G06B05I:		{ return 16; }break;
		case PIXELFORMAT_X01R05G05B05I:		{ return 16; }break;
		case PIXELFORMAT_A01R05G05B05I:		{ return 16; }break;
		case PIXELFORMAT_P08X08R08G08B08I:	{ return  8; }break;
		case PIXELFORMAT_P08A08R08G08B08I:	{ return  8; }break;

		case PIXELFORMAT_DXT1:			{ return  4; }break;
		case PIXELFORMAT_DXT2:			{ return  8; }break;
		case PIXELFORMAT_DXT3:			{ return  8; }break;
		case PIXELFORMAT_DXT4:			{ return  8; }break;
		case PIXELFORMAT_DXT5:			{ return  8; }break;

		case PIXELFORMAT_D16:			{ return 16; }break;
		case PIXELFORMAT_D32:			{ return 32; }break;
		case PIXELFORMAT_D24X8:			{ return 32; }break;
		case PIXELFORMAT_D24S8:			{ return 32; }break;

		}
		MAID_ASSERT( true, "sȃtH[}bgł" );
		return 0;
	}

	/*!
	 	@brief	sNZtH[}bgCLUTP肠Ɏgp
	\n			rbg߂
	 
	 	@param	Format	[i ]	߂tH[}bg
	 
	 	@return	߂rbg
	 */
	inline int GetCLUTBPP( PIXELFORMAT Format )
	{
		switch( Format )
		{
		case PIXELFORMAT_NONE:
		case PIXELFORMAT_A08R08G08B08I:
		case PIXELFORMAT_X08R08G08B08I:
		case PIXELFORMAT_R08G08B08I:
		case PIXELFORMAT_A04R04G04B04I:
		case PIXELFORMAT_R05G06B05I:
		case PIXELFORMAT_X01R05G05B05I:
		case PIXELFORMAT_A01R05G05B05I:
		case PIXELFORMAT_DXT1:
		case PIXELFORMAT_DXT2:
		case PIXELFORMAT_DXT3:
		case PIXELFORMAT_DXT4:
		case PIXELFORMAT_DXT5:
		case PIXELFORMAT_D16:
		case PIXELFORMAT_D32:
		case PIXELFORMAT_D24X8:
		case PIXELFORMAT_D24S8:
			{ return 0; }break;

		case PIXELFORMAT_P08X08R08G08B08I:	{ return  32; }break;
		case PIXELFORMAT_P08A08R08G08B08I:	{ return  32; }break;
		}
		MAID_ASSERT( true, "sȃtH[}bgł" );
		return 0;
	}

	/*!
	 	@brief	sNZtH[}bgpbg̃CfbNX߂
	 
	 	@param	Format	[i ]	߂tH[}bg
	 
	 	@return	CfbNX
	 */
	inline int GetCLUTLength( PIXELFORMAT Format )
	{
		switch( Format )
		{
		case PIXELFORMAT_NONE:
		case PIXELFORMAT_A08R08G08B08I:
		case PIXELFORMAT_X08R08G08B08I:
		case PIXELFORMAT_R08G08B08I:
		case PIXELFORMAT_A04R04G04B04I:
		case PIXELFORMAT_R05G06B05I:
		case PIXELFORMAT_X01R05G05B05I:
		case PIXELFORMAT_A01R05G05B05I:
		case PIXELFORMAT_DXT1:
		case PIXELFORMAT_DXT2:
		case PIXELFORMAT_DXT3:
		case PIXELFORMAT_DXT4:
		case PIXELFORMAT_DXT5:
		case PIXELFORMAT_D16:
		case PIXELFORMAT_D32:
		case PIXELFORMAT_D24X8:
		case PIXELFORMAT_D24S8:
			{ return 0; }break;

		case PIXELFORMAT_P08X08R08G08B08I:	{ return  256; }break;
		case PIXELFORMAT_P08A08R08G08B08I:	{ return  256; }break;
		}
		MAID_ASSERT( true, "sȃtH[}bgł" );
		return 0;
	}

	/*!
	 	@brief	keNX`ׂ
	 
	 	@param	Format	[i ]	ׂtH[}bg
	 
	 	@return	keNX`ł true
	 */
	inline bool IsCompressSurfaceBuffer( PIXELFORMAT Format )
	{
		return PIXELFORMAT_COMPLESSCOLORBEGIN<Format && Format<PIXELFORMAT_COMPLESSCOLOREND;
	}

	/*!
	 	@brief	sNZ܂ނׂ
	 
	 	@param	Format	[i ]	ׂtH[}bg
	 
	 	@return	sNZȂ true
	 */
	inline bool IsAlphaPixel( PIXELFORMAT Format )
	{
		switch( Format )
		{
		case PIXELFORMAT_A08R08G08B08I:
		case PIXELFORMAT_A04R04G04B04I:
		case PIXELFORMAT_A01R05G05B05I:
		case PIXELFORMAT_P08A08R08G08B08I:
		case PIXELFORMAT_DXT2:
		case PIXELFORMAT_DXT3:
		case PIXELFORMAT_DXT4:
		case PIXELFORMAT_DXT5: { return true; }
		}
		return false;
	}

}


#endif
