/*!	
	@file
	@brief	Q[gʗ̈
*/



#ifndef CSurfaceRenderTarget_h
#define CSurfaceRenderTarget_h

#include"../Setup/CompileMode.h"
#include"CSurface.h"

namespace Maid
{
	class CStorageCore;
	class CSurfaceRenderTarget : public CSurface , public GlobalPointer<CStorageCore>
	{
	public:
		virtual mstring GetID()const;
		virtual SIZE2DI GetSize() const;
		virtual PIXELFORMAT GetFormat() const;

	public:
		CSurfaceRenderTarget();
		CSurfaceRenderTarget( const CSurfaceRenderTarget& rha );
		~CSurfaceRenderTarget();
		CSurfaceRenderTarget& operator = ( const CSurfaceRenderTarget& rha );

		void Create( const SIZE2DI& size, PIXELFORMAT fmt );

		void Delete();

		void SaveFile( const mstring& FileName );
		void SaveFile( const mstring& FileName, const SIZE2DI& size );
		bool IsSaving();

	private:
		mstring	m_ID;
		SIZE2DI m_Size;
		PIXELFORMAT m_Format;
		
		static int s_CreateCount;

		enum STATE
		{
			STATE_EMPTY,
			STATE_CREATE,
			STATE_GETSURFACE,
			STATE_SAVESURFACE,
		};

		STATE	m_State;

		mstring m_SaveFileName;
		int		m_TickeID;
		SIZE2DI m_SaveSize;
	};

}

#endif
