#include"CTextureFile.h"

#include"CGraphic.h"

#include"../Storage/Core/CStorageCore.h"
#include"../Storage/DefaultFunction/LoadTexture.h"
#include"CResourceNameGenerator.h"


namespace Maid
{


CTextureFile::CTextureFile()
	:ITextureFile()
{
}

CTextureFile::CTextureFile( const CTextureFile& rha )
	:ITextureFile( rha )
{

}


CTextureFile::~CTextureFile()
{
	//	Yꂸ
	Delete();
}



SIZE2DI		CTextureFile::GetSize()const
{
	return GetOption().ImageSize;
}


PIXELFORMAT	CTextureFile::GetPixelFormat()const
{
	return GetOption().PixelFormat;
}


mstring CTextureFile::GetID() const
{
	return TEXTURENAME::GeneratFile( GetFileName() );
}

CTextureFile& CTextureFile::operator = ( const CTextureFile& rha )
{
	Delete();

	const mstring name = rha.GetFileName();

	if( !name.empty() )
	{
		Load(name);
	}

	return *this;
}






void CTextureFile::LoadedDelete( const mstring& FileName )
{
	const mstring id =  TEXTURENAME::GeneratFile( GetFileName() );
	GlobalPointer<CGraphic>::Get()->DeleteTexture( id );
}

void CTextureFile::LoadEnd( const SPSTORAGEFUNCTION_RETURNPARAM& pParam,  TEXTUREINFO& info )
{
	LoadTextureReturn* pRet = static_cast<LoadTextureReturn*>(pParam.get());

	const CTextureBufferMemory& tex = *(pRet->pTexture);
	
	info.ImageSize   = tex.GetSize();
	info.PixelFormat = tex.GetPixelFormat();

	//	
	const mstring id =  TEXTURENAME::GeneratFile( GetFileName() );

	GlobalPointer<CGraphic>::Get()->RegistTexture( id, pRet->pTexture );
}


}

