#include"CTextureRenderTarget.h"

#include"CGraphic.h"
#include"CResourceNameGenerator.h"

namespace Maid
{
int		CTextureRenderTarget::s_CreateCount;

SIZE2DI		CTextureRenderTarget::GetSize()const
{
	MAID_ASSERT( m_ID.empty(), MAIDTEXT("܂쐬Ă܂") );
	return m_Size;
}

PIXELFORMAT	CTextureRenderTarget::GetPixelFormat()const
{
	MAID_ASSERT( m_ID.empty(), MAIDTEXT("܂쐬Ă܂") );
	return m_Format;
}

mstring CTextureRenderTarget::GetID() const
{
	MAID_ASSERT( m_ID.empty(), MAIDTEXT("܂쐬Ă܂") );
	return m_ID;
}



CTextureRenderTarget::CTextureRenderTarget()
{

}

CTextureRenderTarget::CTextureRenderTarget( const CTextureRenderTarget& rha )
{
	if( rha.m_ID.empty() ) { return ; }

	//	{ȂeNX`ẽRs[KvǁA߂ǂ̂łȂ
	Create( rha.m_Size, rha.m_Format );
}

CTextureRenderTarget::~CTextureRenderTarget()
{
	Delete();
}

CTextureRenderTarget& CTextureRenderTarget::operator = ( const CTextureRenderTarget& rha )
{
	Delete();
	if( rha.m_ID.empty() ) { return *this; }
	Create( rha.m_Size, rha.m_Format );

	return *this;
}


void CTextureRenderTarget::Create( const SIZE2DI& size, PIXELFORMAT fmt )
{
	Delete();

	const mstring id = TEXTURENAME::GeneratRenderTarget( s_CreateCount );

	++s_CreateCount;
	m_ID     = id;
	m_Size   = size;
	m_Format = fmt;



	GlobalPointer<CGraphic>::Get()->RegistRTTexture( id, GetTextureSize(), fmt );

}

void CTextureRenderTarget::Delete()
{
	if( m_ID.empty() ) { return ; }

	GlobalPointer<CGraphic>::Get()->DeleteTexture( m_ID );

	m_ID.clear();
}


}

