/*!	
	@file
	@brief	_OłeNX`
*/

#ifndef CTextureRenderTarget_h
#define CTextureRenderTarget_h


#include"../Setup/CompileMode.h"
#include"CTexture.h"

namespace Maid
{
	class CTextureRenderTarget : public CTexture
	{
	public:
		virtual SIZE2DI		GetSize()const;
		virtual PIXELFORMAT	GetPixelFormat()const;
		virtual mstring GetID() const;

	public:
		CTextureRenderTarget();
		CTextureRenderTarget( const CTextureRenderTarget& rha );
		~CTextureRenderTarget();
		CTextureRenderTarget& operator = ( const CTextureRenderTarget& rha );
	
		void Create( const SIZE2DI& size, PIXELFORMAT fmt );
		void Delete();

	private:
		mstring	m_ID;
		SIZE2DI m_Size;
		PIXELFORMAT	m_Format;
		static int s_CreateCount;
	};
}

#endif
