#ifndef COLOR_A01R05G05B05I_h
#define COLOR_A01R05G05B05I_h

/*!
 	\file
 	\brief	PsNZ킷NX
\n			A01R05G05B05 integer tH[}bg Ver.
 */
#include"../../Setup/CompileMode.h"
#include"../../Auxiliary/Macro.h"

#include"PixelConvertFunction.h"

namespace Maid
{
	/*!
	 	@class	COLOR_A01R05G05B05I COLOR_A01R05G05B05I.h
	 	@brief	J[L[LPUrbgsNZ
	 */
	class COLOR_A01R05G05B05I
	{
	public:
		COLOR_A01R05G05B05I(){}	//!<	RXgN^
		COLOR_A01R05G05B05I( unt08 a, unt08 r, unt08 g, unt08 b ){ SetARGB( a, r, g, b ); }	//!<	RXgN^
		template <class COLOR>
		COLOR_A01R05G05B05I( const COLOR& Col ){ SetARGB( Col.GetA(), Col.GetR(), Col.GetG(), Col.GetB() ); }	//!<	RXgN^

		unt08 GetA() const	{ return PIXELCONVERT01_08((m_ARGB&0x8000)>>15);	}	//!<	At@̎擾
		unt08 GetR() const	{ return PIXELCONVERT05_08((m_ARGB&0x7C00)>>10);	}	//!<	Ԑ̎擾
		unt08 GetG() const	{ return PIXELCONVERT05_08((m_ARGB&0x03E0)>> 5);	}	//!<	ΐ̎擾
		unt08 GetB() const	{ return PIXELCONVERT05_08((m_ARGB&0x001F)<< 3);	}	//!<	̎擾

		operator unt16() const { return m_ARGB; }	//!<	ꊇϊ

		void SetA( unt08 a )	{ m_ARGB = (m_ARGB&~0x8000)|(PIXELCONVERT08_01(a)<<15);	}	//!<	At@̐ݒ
		void SetR( unt08 r )	{ m_ARGB = (m_ARGB&~0x7C00)|(PIXELCONVERT08_05(r)<<10);	}	//!<	Ԑ̐ݒ
		void SetG( unt08 g )	{ m_ARGB = (m_ARGB&~0x03E0)|(PIXELCONVERT08_05(g)<< 5);	}	//!<	ΐ̐ݒ
		void SetB( unt08 b )	{ m_ARGB = (m_ARGB&~0x001F)|(PIXELCONVERT08_05(b)<< 0);	}	//!<	̐ݒ

		void SetARGB( unt08 a, unt08 r, unt08 g, unt08 b )	//!<	ɐݒ
		{
			SetA( a );
			SetR( r );
			SetG( g );
			SetB( b );
		}


		//!	ႤsNZtH[}bgƂ̃Rs[
		template <class PIXEL>
		COLOR_A01R05G05B05I& operator = (const PIXEL &src)
		{
			SetARGB(src.GetA(),src.GetR(),src.GetG(),src.GetB());
			return *this;
		}

		//!	sNZtH[}bgƂ̃Rs[
		COLOR_A01R05G05B05I& operator = (const COLOR_A01R05G05B05I& src)
		{
			m_ARGB = src.m_ARGB;
			return *this;
		}

	private:
		unt16 m_ARGB;
	};
}

#endif
