#ifndef COLOR_R08G08B08I_h
#define COLOR_R08G08B08I_h

/*!
 	@file
 	@brief	PsNZ킷NXS
\n			RGB888 tH[}bg Ver.
 */
#include"../../Setup/CompileMode.h"
#include"../../Auxiliary/Macro.h"

namespace Maid
{
	/*!
	 	@class	COLOR_R08G08B08I COLOR_R08G08B08I.h
	 	@brief	At@QSrbgsNZ
	 */
	class COLOR_R08G08B08I
	{
	public:
		COLOR_R08G08B08I(){}	//!<	RXgN^
		COLOR_R08G08B08I( unt08 r, unt08 g, unt08 b ) { SetRGB(r,g,b); }	//!<	RXgN^
		COLOR_R08G08B08I( unt08 a, unt08 r, unt08 g, unt08 b ) { SetRGB(r,g,b); }	//!<	RXgN^
		template <class COLOR>
		COLOR_R08G08B08I( const COLOR& Col ){  SetRGB( Col.GetR(), Col.GetG(), Col.GetB() );  }	//!<	RXgN^


		unt08 GetA()const	{ return 0xFF;		}	//!<	̎擾
		unt08 GetR()const	{ return m_Red;		}	//!<	Ԑ̎擾
		unt08 GetG()const	{ return m_Green;	}	//!<	ΐ̎擾
		unt08 GetB()const	{ return m_Blue;	}	//!<	̎擾
		unt32 Get() const	{ return (m_Red<<16)|(m_Green<<8)|(m_Blue<<0); }	//!<	32BitColotƂĎ擾

		operator unt32()const{ return Get(); }	//!<	ꊇϊ

		void SetA( unt08 a )	{ }					//!<	Ԑ̐ݒ
		void SetR( unt08 r )	{ m_Red   = r;	}	//!<	Ԑ̐ݒ
		void SetG( unt08 g )	{ m_Green = g;	}	//!<	ΐ̐ݒ
		void SetB( unt08 b )	{ m_Blue  = b;	}	//!<	̐ݒ

		void SetRGB( unt08 r, unt08 g, unt08 b )	//!<	ɐݒ
		{
			SetR( r );
			SetG( g );
			SetB( b );
		}

		//!	ႤsNZtH[}bgƂ̃Rs[
		template <class PIXEL>
		COLOR_R08G08B08I& operator = (const PIXEL &src)
		{
			SetRGB(src.GetR(),src.GetG(),src.GetB());
			return *this;
		}
		//!	sNZtH[}bgƂ̃Rs[
		COLOR_R08G08B08I& operator = (const COLOR_R08G08B08I& src)
		{
			m_Blue = src.m_Blue;
			m_Green = src.m_Green;
			m_Red = src.m_Red;
			return *this;
		}
	private:
		unt08 m_Blue;
		unt08 m_Green;
		unt08 m_Red;
	};

}

#endif
