/*!
 	@file
 	@brief	rbgႤFϊ鎞Ɏge[u
 */
#ifndef PixelConvertFunction_h
#define PixelConvertFunction_h

#include"../../Setup/CompileMode.h"

namespace Maid
{
	/*!
	 	5BitColor -> 8BitColor ϊe[u
	 
	 	@return 8Bitl
	 */
	inline unt08 PIXELCONVERT05_08( unt08 s )
	{
		return (s<<3)|(s>>2);
	}

	/*!
	 	8BitColor -> 5BitColor ϊe[u
	 
	 	@return 5Bitl
	 */
	inline unt08 PIXELCONVERT08_05( unt08 s )
	{
		return s>>3;
	}

	/*!
	 	6BitColor -> 8BitColor ϊe[u
	 
	 	@return 8Bitl
	 */
	inline unt08 PIXELCONVERT06_08( unt08 s )
	{
		return (s<<2)|(s>>4);
	}

	/*!
	 	8BitColor -> 6BitColor ϊe[u
	 
	 	@return 5Bitl
	 */
	inline unt08 PIXELCONVERT08_06( unt08 s )
	{
		return s>>2;
	}

	/*!
	 	8BitColor -> 1BitColor ϊe[u
	\n	gȂ
	 
	 	@return 1Bitl
	 */
	inline unt08 PIXELCONVERT08_01( unt08 s )
	{
		return s>>7;
	}

	/*!
	 	1BitColor -> 8BitColor ϊe[u
	 
	 	@return 8Bitl
	 */
	inline unt08 PIXELCONVERT01_08( unt08 s )
	{
		return (~s)+1;
	}


	/*!
	 	8BitColor -> 4BitColor ϊe[u
	 
	 	@return 4Bitl
	 */
	inline unt08 PIXELCONVERT08_04( unt08 s )
	{
		return s>>4;
	}

	/*!
	 	4BitColor -> 8BitColor ϊe[u
	 
	 	@return 8Bitl
	 */
	inline unt08 PIXELCONVERT04_08( unt08 s )
	{
		return (s<<4)|s;
	}

}

#endif
