/*!	
	@file
	@brief	Q[爵_̊{NX
*/

#ifndef CGraphicCore_h
#define CGraphicCore_h

#include"../../Setup/CompileMode.h"
#include"../../Auxiliary/Thread/CThreadController.h"
#include"../../Auxiliary/Thread/CThreadMutex.h"
#include"../../Template/Mathematics.h"

#include"../Color.h"

#include"Driver/CVideoCardDriver.h"
#include"Driver/CSurfaceBuffer.h"
#include"Driver/CTextureBuffer.h"
#include"Driver/CVertexBuffer.h"
#include"Driver/CIndexBuffer.h"
#include"Driver/CVertexShaderBuffer.h"
#include"Driver/CPixelShaderBuffer.h"
#include"Driver/CVertexDeclarationBuffer.h"

#include"../CRenderMessage.h"
#include"../CReturnMessage.h"
#include<vector>
#include<list>
#include<map>

namespace Maid
{
	class CGraphicCore
	{
	public:
		CGraphicCore();
		virtual ~CGraphicCore();

		void Initialize( const SPVIDEOCARDDRIVER& pDriver, const IVideoCardDriver::SCREENMODE& Mode );
		void Finalize();

		void SwapRenderMessage( RENDERMESSAGEQUE& mess );
		void DrawFrame( RETURNMESSAGEQUE& Return );

	private:
		void ExecuteRenderMessage( const SPRENDERMESSAGE& pMessage, RETURNMESSAGEQUE& Return );
		void ScreenTest();


	private:
		SPVIDEOCARDDRIVER	m_pDriver;
		RENDERMESSAGEQUE	m_RenderQue;	//	ݏ̕`惁bZ[W
		IVideoCardDriver::SCREENMODE	m_DefaultScreenMode;	//	ݒ

		struct TEXTUREINFO
		{
			TEXTUREINFO() : IsManaged(false){}
			TEXTUREINFO( const SPTEXTUREBUFFER& pBuf ) : pBuffer(pBuf), IsManaged(false){}
			TEXTUREINFO( const SPTEXTUREBUFFER& pBuf, bool b ) : pBuffer(pBuf), IsManaged(b){}
			SPTEXTUREBUFFER	pBuffer;
			bool			IsManaged;	//	n[hŊǗĂ邩H
		};


		typedef MySTL::map<mstring,SPSURFACEBUFFER>			SURFACEMAP;
		typedef MySTL::map<mstring,TEXTUREINFO>			TEXTUREMAP;
		typedef MySTL::map<mstring,SPINDEXBUFFER>			INDEXMAP;
		typedef MySTL::map<mstring,SPVERTEXBUFFER>			VERTEXMAP;
		typedef MySTL::map<mstring,SPVERTEXSHADERBUFFER>	VERTEXSHADERMAP;
		typedef MySTL::map<mstring,SPPIXELSHADERBUFFER>		PIXELSHADERMAP;
		typedef MySTL::map<mstring,SPVERTEXDECLARATIONBUFFER>		DECLARATIONMAP;
		SURFACEMAP		m_SurfaceMap;
		TEXTUREMAP		m_TextureMap;
		INDEXMAP		m_IndexMap;
		VERTEXMAP		m_VertexMap;
		VERTEXSHADERMAP	m_VertexShaderMap;
		PIXELSHADERMAP	m_PixelShaderMap;
		DECLARATIONMAP	m_DeclarationMap;

	};
}


#endif
