/*!
 	@file
 	@brief	tHgǗĂx[XNX
 */
#ifndef CFontDriver_h
#define CFontDriver_h

#include"../../../Setup/CompileMode.h"
#include"../../../Auxiliary/mstring.h"
#include"../../../template/Mathematics.h"
#include<boost/smart_ptr.hpp>

#include"../../CFont.h"
#include"CSurfaceBuffer.h"

namespace Maid
{
	/*!
	 	@brief	tHgǗĂx[XNX
	\n			̃NXpĊeg悤ɂ܂
	 */
	class IFontDriver
	{
	public:
		virtual ~IFontDriver(){}	//!<	fXgN^

		//! tHg̍쐬
		/*!
		 	@param	FontNo		[i ]	쐬tHgԍ 0<=FontNo<=GetFontNum() ł邱ƁiO͕K쐬ł)
		 	@param	FontW		[i ]	tHgP̉(PixelP)
		 	@param	FontH		[i ]	tHgP̏c(PixelP)
		 	@param	IsAntialias	[i ]	A`GCAX邩H
		 	@param	IsBold		[i ]	ɂ邩H
		 	@param	IsItalic	[i ]	C^bNɂ邩H
		 
		 	@return	쐬ꂽtHg
		 */
		virtual SPFONT Create( int FontNo, int FontW, int FontH, bool IsAntialias, bool IsBold, bool IsItalic ) const=0;


		//! tHg̍쐬
		/*!
		 	@param	FontName	[i ]	쐬tHg
		 	@param	FontW		[i ]	tHgP̉(PixelP)
		 	@param	FontH		[i ]	tHgP̏c(PixelP)
		 	@param	IsAntialias	[i ]	A`GCAX邩H
		 	@param	IsBold		[i ]	ɂ邩H
		 	@param	IsItalic	[i ]	C^bNɂ邩H
		 
		 	@return	쐬ꂽtHg
		 */
		virtual SPFONT Create( const mstring& FontName, int FontW, int FontH, bool IsAntialias, bool IsBold, bool IsItalic ) const=0;

		//! Sł̃tHg邩擾
		/*!
		 	@return	tHĝ鐔
		 */
		virtual int GetFontNum() const=0;

		//! tHg̎擾
		/*!
		 	@param	FontNo	[i ]	ׂtHgԍ
		 
		 	@return	tHg
		 */
		virtual mstring GetFontName( int FontNo ) const=0;


		//! PX^CY
		/*!
		 	@param	pFont		[i ]	X^CYtHg
		 	@param	FontCode	[i ]	X^CY镶R[h(mstring)
		 */
		virtual SPSURFACEBUFFER Rasterize( const SPFONT& pFont, unt32 FontCode ) const=0;

	};
	typedef boost::shared_ptr<IFontDriver> SPFONTDRIVER;
}

#endif
