#ifndef CSurfaceBufferInfoTemplate_h
#define CSurfaceBufferInfoTemplate_h

#include"../../../Setup/CompileMode.h"
#include"CSurfaceBuffer.h"


namespace Maid
{

	/*!
	 	@class	ISurfaceBufferInfoNormal CSurfaceBufferInfoTemplate.h
	 	@brief	C[Weʂ̂
	\n			T͂̃NXł
	 */
	class ISurfaceBufferInfoNormal : public ISurfaceBufferInfo
	{
	public:
		//! RXgN^
		/*! 
		 	@param	pBits	[i ]	C[W̐擪AhX
		 	@param	pCLUT	[i ]	pbg̐擪AhX
		 	@param	Width	[i ]	C[W̉
		 	@param	Height	[i ]	C[W̏c
		 	@param	Format	[i ]	C[W̃sNZtH[}bg
		 	@param	Pitch	[i ]	C[W̃CTCYiPʂ̓oCgj
		 */
		ISurfaceBufferInfoNormal( void* pBits, void* pCLUT, int Width, int Height, PIXELFORMAT Format, int Pitch )
			: m_pBits(pBits), m_pCLUT(pCLUT), m_Width(Width), m_Height(Height), m_Format(Format), m_Pitch(Pitch)
		{

		}

		virtual ~ISurfaceBufferInfoNormal(){}	//!<	fXgN^

		//! ISurfaceInfo::GetLinePtr() Q
		virtual void* GetLinePtr( int PosY )const 
		{
			MAID_ASSERT(!(PosY<(int)GetHeight()),"w肵͈͂𒴂Ă܂" << PosY << GetHeight());
			return (unt08*)m_pBits + m_Pitch*PosY; 
		}

		//! ISurfaceInfo::GetAddress() Q
		virtual void* GetAddress() const { return m_pBits; }


		//! ISurfaceInfo::GetCLUT() Q
		virtual void* GetCLUT() const { return m_pCLUT; }


		//! ISurfaceInfo::GetWidth() Q
		virtual int		GetWidth() const { return m_Width; }

		//! ISurfaceInfo::GetHeight() Q
		virtual int		GetHeight() const { return m_Height; }

		//! ISurfaceInfo::GetPixelFormat() Q
		virtual PIXELFORMAT GetPixelFormat() const { return m_Format; }

		//! ISurfaceInfo::GetPitch() Q
		virtual int		GetPitch() const { return m_Pitch; }

	private:
		void*		m_pBits;
		void*		m_pCLUT;
		int			m_Width;
		int			m_Height;
		PIXELFORMAT	m_Format;
		int			m_Pitch;
	};



	/*!
	 	\class	ISurfaceBufferInfoReverse CSurfaceBufferInfoTemplate.h
	 	\brief	C[We㉺΂̂
	\n			alõNX܂
	 */
	class ISurfaceBufferInfoReverse : public ISurfaceBufferInfo
	{
	public:
		//! RXgN^
		/*! 
		 *	@param	pBits	[i ]	C[W̐擪AhX
		 *	@param	pCLUT	[i ]	pbg̐擪AhX
		 *	@param	Width	[i ]	C[W̉
		 *	@param	Height	[i ]	C[W̏c
		 *	@param	Format	[i ]	C[W̃sNZtH[}bg
		 *	@param	Pitch	[i ]	C[W̃CTCYiPʂ̓oCgj
		 */
		ISurfaceBufferInfoReverse( void* pBits, void* pCLUT, int Width, int Height, PIXELFORMAT Format, int Pitch )
			: m_pBits(pBits), m_pCLUT(pCLUT), m_Width(Width), m_Height(Height), m_Format(Format), m_Pitch(Pitch)
		{

		}

		virtual ~ISurfaceBufferInfoReverse(){}	//!<	fXgN^

		//! ISurfaceInfo::GetLinePtr() Q
		virtual void* GetLinePtr( int PosY )const 
		{
			MAID_ASSERT(!(PosY<(int)GetHeight()),"w肵͈͂𒴂Ă܂ "<< PosY << GetHeight());
			return (unt08*)m_pBits + m_Pitch*(GetHeight()-(PosY+1));
		}

		//! ISurfaceInfo::GetAddress() Q
		virtual void* GetAddress() const { return m_pBits; }

		//! ISurfaceInfo::GetCLUT() Q
		virtual void* GetCLUT() const { return m_pCLUT; }

		//! ISurfaceInfo::GetWidth() Q
		virtual int GetWidth() const { return m_Width; }

		//! ISurfaceInfo::GetHeight() Q
		virtual int GetHeight() const { return m_Height; }

		//! ISurfaceInfo::GetPixelFormat() Q
		virtual PIXELFORMAT GetPixelFormat() const { return m_Format; }

		//! ISurfaceInfo::GetPitch() Q
		virtual int		GetPitch() const { return m_Pitch; }

	private:
		void*		m_pBits;
		void*		m_pCLUT;
		int			m_Width;
		int			m_Height;
		PIXELFORMAT	m_Format;
		int			m_Pitch;
	};
}


#endif