#include"../../../Setup/CompileMode.h"
#include"CSurfaceBufferMemory.h"
#include"CSurfaceBufferInfoTemplate.h"


namespace Maid
{

CSurfaceBufferMemory::CSurfaceBufferMemory()
{
	m_Size = SIZE2DI(0,0);
	m_PixelFormat = PIXELFORMAT_NONE;
}


CSurfaceBufferMemory::~CSurfaceBufferMemory()
{
	Destroy();
}

SIZE2DI CSurfaceBufferMemory::GetSize() const
{
	MAID_ASSERT( m_PixelFormat==PIXELFORMAT_NONE, "܂쐬Ă܂" );
	return m_Size;
}

PIXELFORMAT CSurfaceBufferMemory::GetPixelFormat() const
{
	MAID_ASSERT( m_PixelFormat==PIXELFORMAT_NONE, "܂쐬Ă܂" );
	return m_PixelFormat;
}

void CSurfaceBufferMemory::Lock( SPSURFACEBUFFERINFO& info )
{
	MAID_ASSERT( m_PixelFormat==PIXELFORMAT_NONE, "܂쐬Ă܂" );

	void* pCLUT = NULL;
	void* pPlane = &m_Plane[0];
	
	if( GetCLUTBPP(m_PixelFormat)!=0 )
	{
		pCLUT = &(m_CLUT[0]);
	}

	if( m_IsReverse )
	{
		info.reset( new ISurfaceBufferInfoReverse( 
				pPlane, pCLUT, m_Size.w, m_Size.h, 
				m_PixelFormat, m_Size.w*GetPixelBPP(m_PixelFormat)/8 ) );
	}else
	{
		info.reset( new ISurfaceBufferInfoNormal( 
				pPlane, pCLUT, m_Size.w, m_Size.h, 
				m_PixelFormat, m_Size.w*GetPixelBPP(m_PixelFormat)/8 ) );
	}
}

void CSurfaceBufferMemory::Unlock()
{
	//	邱ƂȂ
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! T[tFX̍쐬
/*!
 	@param	size	[i ]	T[tFX̑傫
 	@param	fmt		[i ]	sNZtH[}bg
 */
void CSurfaceBufferMemory::Create( const SIZE2DI& size, PIXELFORMAT fmt )
{
	Destroy();

	const int bpp  = GetPixelBPP(fmt);
	const int clut = GetCLUTBPP(fmt);
	const int count = GetCLUTLength(fmt);

	m_Plane.resize( size.w * bpp/8 * size.h +16 );

	if( clut!=0 )
	{
		m_CLUT.resize( clut/8 * count +16);
	}

	m_Size = size;
	m_PixelFormat = fmt;
	m_IsReverse = false;
}



/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! T[tFX̔j
/*!
 */
void CSurfaceBufferMemory::Destroy()
{
	m_Plane.clear();
	m_PixelFormat = PIXELFORMAT_NONE;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ̃T[tFX͔]Ăݒs
/*!
	@param	IsReverse	[i ]	]ĂȂ true
 */
void CSurfaceBufferMemory::SetReverseSurface( bool IsReverse )
{
	m_IsReverse = IsReverse;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ZŎ擾
/*!
 */
void* CSurfaceBufferMemory::GetPlanePTR()
{
	return &(m_Plane[0]);
}

}


