#include"../../../Setup/CompileMode.h"
#include"CTextureBufferMemory.h"



namespace Maid
{
	/*!
	 	@class	CTextureBufferMemory CTextureBufferMemory.h
	 	@brief	eNX`obt@ I Ver.
	 */

CTextureBufferMemory::CTextureBufferMemory()
{

}

CTextureBufferMemory::~CTextureBufferMemory()
{
	Destroy();
}

SIZE2DI CTextureBufferMemory::GetSize() const
{
	MAID_ASSERT( m_Surface.empty(), "܂쐬Ă܂" );
	return m_Surface[0].GetSize();
}

PIXELFORMAT CTextureBufferMemory::GetPixelFormat() const
{
	MAID_ASSERT( m_Surface.empty(), "܂쐬Ă܂" );
	return m_Surface[0].GetPixelFormat();
}

int CTextureBufferMemory::GetSurfaceLevel() const
{
	MAID_ASSERT( m_Surface.empty(), "܂쐬Ă܂" );
	return (int)m_Surface.size();
}

ISurfaceBuffer& CTextureBufferMemory::GetSurface( int Level )
{
	return GetSurfaceEx( Level );
}



/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! eNX`̍쐬
/*!
 	@param	size	[i ]	T[tFX̑傫
 	@param	fmt		[i ]	sNZtH[}bg
 	@param	level	[i ]	~bv}bv̖(ftHg1)
 */
void CTextureBufferMemory::Create( const SIZE2DI& size, PIXELFORMAT fmt, int level )
{
	MAID_ASSERT( level==0, "Œł1ɂĂ" );
	Destroy();

	m_Surface.resize(level);

	int w = size.w;
	int h = size.h;

	for( int i=0; i<level; ++i )
	{
		m_Surface[i].Create( SIZE2DI(w,h), fmt );

		w /= 2;
		h /= 2;
	}
}



/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! T[tFX̔j
/*!
 */
void CTextureBufferMemory::Destroy()
{
	m_Surface.clear();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! T[tFX̎擾
/*!
 */
CSurfaceBufferMemory& CTextureBufferMemory::GetSurfaceEx( int Level )
{
	MAID_ASSERT( m_Surface.empty(), "܂쐬Ă܂" );
	MAID_ASSERT( !(Level<(int)m_Surface.size()), "͈͂𒴂Ă܂" );

	if( !(Level<(int)m_Surface.size()) )
	{
		//	{͂Ȃ̂ȂǁAS
		static CSurfaceBufferMemory mem;
		return mem;
	}

	return m_Surface[Level];
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ̃T[tFX͔]Ăݒs
/*!
	@param	IsReverse	[i ]	]ĂȂ true
 */
void CTextureBufferMemory::SetReverseSurface( bool IsReverse )
{
	MAID_ASSERT( m_Surface.empty(), "܂쐬Ă܂" );

	for( int i=0; i<(int)m_Surface.size(); ++i )
	{
		m_Surface[i].SetReverseSurface(IsReverse);

	}
}


}


