#include"CVideoCardDriverD3D9.h"

#include"../../../../../Auxiliary/Debug/CException.h"

namespace Maid
{

	//	ɂ ClearXXX, |S`n

D3DPRIMITIVETYPE toD3DPRIMITIVETYPE( IVideoCardDriver::PRIMITIVE prim )
{
	D3DPRIMITIVETYPE t = D3DPT_TRIANGLELIST;
	switch( prim )
	{
	case IVideoCardDriver::PRIMITIVE_POINTLIST:		{ t = D3DPT_POINTLIST;		}break;
	case IVideoCardDriver::PRIMITIVE_LINELIST:		{ t = D3DPT_LINELIST;		}break;
	case IVideoCardDriver::PRIMITIVE_LINESTRIP:		{ t = D3DPT_LINESTRIP;		}break;
	case IVideoCardDriver::PRIMITIVE_TRIANGLELIST:	{ t = D3DPT_TRIANGLELIST;	}break;
	case IVideoCardDriver::PRIMITIVE_TRIANGLESTRIP:	{ t = D3DPT_TRIANGLESTRIP;	}break;
	case IVideoCardDriver::PRIMITIVE_TRIANGLEFAN:	{ t = D3DPT_TRIANGLEFAN;	}break;
	}

	return t;
}




//!	IVideoCardDriver::ClearColor() Q
void CVideoCardDriverD3D9::ClearColor( const COLOR_R08G08B08I& Color )
{
	HRESULT ret;
	ret = m_pDevice->Clear( 0, NULL, D3DCLEAR_TARGET, Color, 0.0f, 0 );
	if( FAILED(ret) ) { MAID_THROWEXCEPTION(MAIDTEXT("IDirect3DDevice9::Clear()")); }
}

//!	IVideoCardDriver::ClearColor() Q
void CVideoCardDriverD3D9::ClearZ( float val )
{
	HRESULT ret;
	ret = m_pDevice->Clear( 0, NULL, D3DCLEAR_ZBUFFER, 0, val, 0 );
	if( FAILED(ret) ) { MAID_THROWEXCEPTION(MAIDTEXT("IDirect3DDevice9::Clear()")); }
}


//!	IVideoCardDriver::DrawPrimitive() Q
void CVideoCardDriverD3D9::DrawPrimitive( PRIMITIVE prim, unt StartVertex, unt PrimitiveCount )
{
	D3DPRIMITIVETYPE t = toD3DPRIMITIVETYPE(prim);

	HRESULT ret;
	ret = m_pDevice->DrawPrimitive( t, StartVertex, PrimitiveCount );
	if( FAILED(ret) ) { MAID_THROWEXCEPTION(MAIDTEXT("IDirect3DDevice9::DrawPrimitive() ")); }
}

//!	IVideoCardDriver::DrawPrimitiveUP() Q
void CVideoCardDriverD3D9::DrawPrimitiveUP( PRIMITIVE prim, const void* pVertex, unt Stride, unt PrimitiveCount )
{
	D3DPRIMITIVETYPE t = toD3DPRIMITIVETYPE(prim);

	HRESULT ret;
	ret = m_pDevice->DrawPrimitiveUP( t, PrimitiveCount, pVertex, Stride );
	if( FAILED(ret) ) { MAID_THROWEXCEPTION(MAIDTEXT("IDirect3DDevice9::DrawPrimitiveUP() ")); }
}

void CVideoCardDriverD3D9::DrawIndexedPrimitive( PRIMITIVE prim, int BaseVertexOffset, unt MinIndex, unt NumVertices, unt StartIndex, unt PrimitiveCount )
{
	D3DPRIMITIVETYPE t = toD3DPRIMITIVETYPE(prim);

	HRESULT ret;
	ret = m_pDevice->DrawIndexedPrimitive( t, BaseVertexOffset, MinIndex, NumVertices, StartIndex, PrimitiveCount );
	if( FAILED(ret) ) { MAID_THROWEXCEPTION(MAIDTEXT("IDirect3DDevice9::DrawIndexedPrimitive() ")); }
}


void CVideoCardDriverD3D9::DrawIndexPrimitiveUP( PRIMITIVE prim, int MinIndex, int NumVertices, const void* pVertex, int VertexSize, int PrimitiveCount, const void* pIndex, int IndexSize  )
{
	D3DPRIMITIVETYPE t = toD3DPRIMITIVETYPE(prim);

	const  D3DFORMAT ifmt = IndexSize==2? D3DFMT_INDEX16 : D3DFMT_INDEX32;

	HRESULT ret;
	ret = m_pDevice->DrawIndexedPrimitiveUP( t, MinIndex, NumVertices, PrimitiveCount, pIndex, ifmt, pVertex, VertexSize );
	if( FAILED(ret) ) { MAID_THROWEXCEPTION(MAIDTEXT("IDirect3DDevice9::DrawIndexPrimitiveUP() ")); }
}


}

