
#include"CInputMethodDriverWindows.h"
#include"../../Auxiliary/CString.h"

#include<imm.h>
#pragma comment(lib, "imm32.lib")


namespace Maid
{
/*!
 	@class	CInputMethodDriverWindows CInputMethodDriverWindows.h
 	@brief	FEPǗNX
\n			IME ̏Ԃ͂ĂeLXg擾łNX
 *			http://www.honet.ne.jp/~tri/program/noime.html
 */


	//	releaseNX
	class IMCHandle
	{
	public:
		IMCHandle( HWND hWnd )
		{
			m_hImc = ::ImmGetContext(hWnd);
			m_hWnd = hWnd;
		}
		~IMCHandle()
		{
			::ImmReleaseContext(m_hWnd,m_hImc);
		}

		HIMC Get() { return m_hImc; }
	private:
		HWND	m_hWnd;
		HIMC	m_hImc;
	};


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!
 */
CInputMethodDriverWindows::CInputMethodDriverWindows()
{
    m_hWnd = NULL;
    m_pCandidateList = NULL;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fXgN^
/*!
 */
CInputMethodDriverWindows::~CInputMethodDriverWindows()
{
    Release();
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! FEP̊J
/*!
*/
void CInputMethodDriverWindows::Release()
{
	m_hWnd = NULL;
	m_pCandidateList = NULL;
	DelProc();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! FEP ̏
/*!
 	@param	hWnd	[i ]	֘AEBhEnh
 */
void CInputMethodDriverWindows::Initialize(HWND hWnd)
{
    Release();

	m_hWnd = hWnd;
	m_IsInput = false;

	AddProc( hWnd );
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! FEP ̋N
/*!
 */
void CInputMethodDriverWindows::Open()
{
	if( IsOpen() ) { return ; }

	IMCHandle hImc(m_hWnd);
	ImmSetOpenStatus(hImc.Get(), TRUE);
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! FEP ̏I
/*!
 */
void CInputMethodDriverWindows::Close()
{
	if( !IsOpen() ) { return ; }

	IMCHandle hImc(m_hWnd);
	ImmSetOpenStatus(hImc.Get(), FALSE);
}




/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! FEP Ă邩H
/*!
 *	\return edoĂȂ true
\n			ĂȂȂ false
 */
bool CInputMethodDriverWindows::IsOpen() const
{
	IMCHandle hImc(m_hWnd);
	const bool IsOpen = ImmGetOpenStatus(hImc.Get())!=0;
	return IsOpen;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ݓ͒H
/*!
 	@return	͒Ȃ true
 */
bool CInputMethodDriverWindows::IsInput() const
{
	return m_IsInput;
}



/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! edo̕ϊԂ擾
/*!
 	@param	pConversion	[i ]	̓[h(pJiASp@j
 	@param	pSentence	[i ]	ϊ[h(ʁEnD@j
 */
void CInputMethodDriverWindows::GetStatus( DWORD* pConversion, DWORD* pSentence) const
{
	IMCHandle hImc(m_hWnd);

	ImmGetConversionStatus(hImc.Get(),pConversion,pSentence);
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ϊʒu̎擾
/*!
 	@return	ϊʒu
 */
int CInputMethodDriverWindows::GetConvertPos() const
{
	IMCHandle hImc(m_hWnd);
    DWORD dwBuff[2];
    if(::ImmGetCompositionString(hImc.Get(),GCS_COMPCLAUSE,dwBuff,sizeof(DWORD)*2) == 0) { return 0; }
    return dwBuff[1];
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! J[\ʒu̎擾
/*!
 	@return	J[\ʒu
 */
int CInputMethodDriverWindows::GetCursorPos() const
{
	IMCHandle hImc(m_hWnd);
    DWORD count = ::ImmGetCompositionString(hImc.Get(),GCS_CURSORPOS,NULL,0);

	// ̖߂l̓oCgŖ߂Ă̂
	//	ɕϊ

	const mstring str = GetCompString();

	int index = 0;

	while( true )
	{
		if( count==0 ) { break; }

		if( str[index]<=0xFF )	{ count -= 1; }
		else					{ count -= 2; }

		++index;
	}

	return index;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ϊ⃊Xg̍쐬
/*!
   GetCountCandidate()
\n GetCandidateIndex()
\n GetCandidateString()
\n GetCandidateStart()
\n GetCandidateEnd()
\n	gOɌĂł
 */
void CInputMethodDriverWindows::UpdateCandidate()
{
	IMCHandle hImc(m_hWnd);
   //ϊ̎擾
	const INT iCandidateSize = ::ImmGetCandidateList(hImc.Get(),0,NULL,0);
	if(iCandidateSize==0) { return; }

	m_pCandidateBuff.reset( new unt08[iCandidateSize] );
    m_pCandidateList = (LPCANDIDATELIST)m_pCandidateBuff.get();

    ::ImmGetCandidateList(hImc.Get(),0,m_pCandidateList,iCandidateSize);
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ϊ␔̎擾
/*!
 	@return ϊ␔
 */
int CInputMethodDriverWindows::GetCandidateCount() const
{
	if( m_pCandidateList==NULL ) { return 0; }
	return m_pCandidateList->dwCount;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ݑI𒆂̕ϊ̎擾
/*!
 	@return ϊʒu
 */
int CInputMethodDriverWindows::GetCandidateSelect() const
{
	if(m_pCandidateList==NULL) { return 0; }
    return m_pCandidateList->dwSelection;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! FEP͕̎擾
/*!
 	@return	͒̕
 */
mstring CInputMethodDriverWindows::GetCompString() const
{
	if( !IsInput() ) { return mstring(); }

	IMCHandle hImc(m_hWnd);
    const LONG lByte = ::ImmGetCompositionString(hImc.Get(),GCS_COMPSTR,NULL,0);

	if( lByte==0 ) { return mstring(); }

	MySTL::string	Buff;
	Buff.resize(lByte);

    ::ImmGetCompositionString( hImc.Get(), GCS_COMPSTR, &Buff[0], lByte);
 
	return CString::ConvertSJIStoMAID(Buff);
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! w肳ꂽCfbNX̕ϊ擾
/*!
 	@return ϊ╶
 */
mstring CInputMethodDriverWindows::GetCandidateString(int Index) const
{
	if(m_pCandidateList==NULL) { return mstring(); }

	MySTL::string ret = (char*)m_pCandidateList+m_pCandidateList->dwOffset[Index];

    return CString::ConvertSJIStoMAID( ret );
}

void CInputMethodDriverWindows::SetResultCodeFunction( const RESULTCODEFUNCTION& Function )
{
	m_Function = Function;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! EBhEvV[W
/*!
 */
IMessageHook::RETURNCODE CInputMethodDriverWindows::OnMessage( CWindowsMessage& Param )
{
	const bool IsEmptyFunc = !m_Function;
	switch( Param.GetMSG() )
	{
	case WM_IME_SETCONTEXT:
		{
			Param.SetLPARAM( Param.GetLPARAM()&~ISC_SHOWUIALL );
		}break;

	case WM_IME_COMPOSITION:
		{
            if( Param.GetLPARAM()&GCS_RESULTSTR )
			{
				IMCHandle hImc(m_hWnd);
				const LONG lByte = ::ImmGetCompositionString(hImc.Get(),GCS_RESULTSTR,NULL,0);
				if( lByte==0 ) { break; }

				MySTL::string	str;
				str.resize(lByte);

				::ImmGetCompositionString( hImc.Get(), GCS_RESULTSTR, &str[0], lByte);

				if( !IsEmptyFunc )
				{
					m_Function( CString::ConvertSJIStoMAID(str) );
				}
			}
			return IMessageHook::RETURNCODE_EXIT;
		}
		break;

	case WM_IME_STARTCOMPOSITION: { m_IsInput = true; return IMessageHook::RETURNCODE_EXIT;}break;
	case WM_IME_ENDCOMPOSITION:   { m_IsInput = false; return IMessageHook::RETURNCODE_EXIT;}break;

	case WM_IME_NOTIFY:
		{
			switch(Param.GetWPARAM())
			{
			case IMN_OPENSTATUSWINDOW:
			case IMN_CLOSESTATUSWINDOW:
				{
					return IMessageHook::RETURNCODE_EXIT;
				}break;

			case IMN_OPENCANDIDATE:
			case IMN_CHANGECANDIDATE:
			case IMN_CLOSECANDIDATE:
				{
					UpdateCandidate();
					return IMessageHook::RETURNCODE_EXIT;
				}break;
			}
		}break;

	}

	return IMessageHook::RETURNCODE_CONTINUE;
}

}



/*

  http://www.geocities.co.jp/SiliconValley-Cupertino/5872/Message/WM/
  ̔o

WM_IME_CHAR = &H286 
	@\ 
		IMEϊʂ̕󂯎ƂAAvP[Vɑ
 
	wParam 
		1oCĝ̕ƂASCUl
		2oCĝ̕ƂVtgJISR[h
 
	lParam 
		L[Xg[NbZ[W
 


WM_IME_COMPOSITION = &H10F 
@\ 
L[̓͂̌ʁAϊ񂪕ωƂɃAvP[Vɑ
 
wParam 
ϊɑ΂čŌ̕ω\2oCg
 
lParam 
ϊ񂪕ω\萔̑gݍ킹
萔                  l         e
---------------------------------------------------------------------------
GCS_COMPATTR          &H10       ϊ̑擾XV
GCS_COMPLAUSE         &H20       ϊ̋擾XV
GCS_COMPREADATTR      &H2        ݂̕ϊ̓ǂ݂̑擾EXV
GCS_COMPREADCLAUSE    &H4        ݂̓̕ǂ݂̋擾XV
GCS_COMPREADSTR       &H1        ݂̕ϊ̓ǂ݂擾EXV
GCS_COMPSTR           &H8        ݂̕ϊ擾EXV
GCS_CURSORPOS         &H80       ϊ̃J[\̈ʒu擾XV
GCS_RESULTCLAUSE      &H1000     ϊ㕶̋擾EXV
GCS_RESULTREADCLAUSE  &H400      ϊ㕶̓ǂ݂̋擾XV
GCS_RESULTREADSTR     &H200      ϊ㕶̓ǂ݂̑擾XV
GCS_RESULTSTR         &H800      ϊ㕶擾XV
---------------------------------------------------------------------------
 
l 
̃bZ[WSDK͕̉sȓ_
 



@\ 
ϊEBhË̗mۂłȂƂAAvP[Vɑ
 
wParam 
0
 
lParam 
0
 
l 
̃bZ[W󂯎ꍇ
IME_SETCOMPOSITIONWINDOWgĕ\@w肷
 


  WM_IME_CONTROL = &H283 
@\ 
AvP[V쐬IMEEBhEɑ΂
sׂeIMEEBhEɑ郁bZ[W
 
wParam 
ew肷tbO(IMC_xxx)
 
lParam 
wParam̐ݒɉl
 
߂l 
lParam߂
 

WM_IME_ENDCOMPOSITION = &H10E
  @\ 
IMEϊIƂAvP[Vɑ
 
wParam 
0
 
lParam 
0
 





WM_IME_KEYDOWN = &H290 
L[ƂAvP[Vɑ
 
wParam 
zL[R[h
 
lParam 
L[Xg[NbZ[W
 


WM_IME_KEYUP = &H291 
@\ 
L[𗣂ƂAvP[Vɑ
 
wParam 
zL[R[h
 
lParam 
L[Xg[NbZ[W
 





WM_IME_NOTIFY = &H282 
@\ 
IMEEBhEɕωƂAvP[Vɑ
 
wParam 
IMEEBhE̎sew肷tbO(IMN_xxx)
 
lParam 
wParamɉl
 
l 
AvP[VIMEEBhȆSĂ̓ɑ΂
ӔCꍇɎgbZ[W
 




WM_IME_REQUEST = &H288 
@\ 
IMȄԂɊւv

 
wParam 
vew肷tbO(IMR_xxx)
 
lParam 
wParamɉl
 
l 
AvP[VIMEEBhEǗꍇɎg
 


WM_IME_SELECT = &H285 
@\ 
VXeIMEύX悤ƂĂƂAAvP[Vɑ
 
wParam 
݂IMEIĂƂ   1
IĂȂƂ              0
 
lParam 
IMEɊ֘AtĂL[{[hCAEg̃nh
 


WM_IME_SETCONTEXT = &H281 
@\ 
AvP[ṼEBhEANeBuɂȂƂ
AvP[Vɑ
 
wParam 
̓ReLXgANeBuȂƂ     1
ANeBułȂƂ                   0
 
lParam 
\EBhEw肷tbO(IMC_xxx)
 

WM_IME_STARTCOMPOSITION = &H10D 
@\ 
L[͂ɂĕϊ񂪐钼OɃAvP[Vɑ
 
wParam 
0
 
lParam 
0
 

http://www.honet.ne.jp/~tri/program/noime.html
̂҂

  IMEŕ\Ȃ@@`U@`
ڂ́Aɕ`~߂@łIME֘ÃbZ[W邱ƂŎł܂B

switch(uMsg){
case WM_IME_SETCONTEXT:
    lParam &= ~ISC_SHOWUIALL;
    break;
case WM_IME_STARTCOMPOSITION:
case WM_IME_COMPOSITION:
case WM_IME_ENDCOMPOSITION:
    return 0;
case WM_IME_NOTIFY:
    switch(wParam){
    case IMN_OPENSTATUSWINDOW:
    case IMN_CLOSESTATUSWINDOW:
    case IMN_OPENCANDIDATE:
    case IMN_CHANGECANDIDATE:
    case IMN_CLOSECANDIDATE:
        return 0;
    default:
        return DefWindowProc(..[]..);
    }
default
    return DefWindowProc(..[]..);
}

Ƃ܂ȊBԂɐĂƁc

WM_IME_SETCONTEXT
̃bZ[W͊{IɃEBhEANeBu/ANeBuɂȂƂɑĂ܂B 
̒LPARAMIME֘ÃEBhEĕ`悷邩ǂtOŎw肳Ă܂B
ŁAł͑S\Kv͖̂ISC_SHOWUIALLŕ\tOSďčĕ`悳Ă܂B
ŏMSDÑhLgāAũbZ[WĂ΁Aƕ`悳ȂvƊႢĂ܂BiGLtj
ۂ͂̃bZ[Wɕ`悪ȂŁA̍ĕ`̃^C~OΕ`悳Ă܂܂B


WM_IME_STARTCOMPOSITION/WM_IME_COMPOSITION/WM_IME_ENDCOMPOSITION
̃bZ[W͕ϊ񂪑삳ꂽɑĂ܂B
{IMEƃA_[CĂ镶̎łB 
̕񂪁uoĂ/ύXꂽ/Ȃvɂꂼꔭ܂B
ŁÃbZ[WDefWindowProc()ɓnȂΕ`悳ȂȂ܂B


IMN_OPENSTATUSWINDOW/IMN_CLOSESTATUSWINDOW
WM_IME_NOTIFŸꕔɂȂ܂A̓̃bZ[W̓c[o[Jƕ鎞ɔł܂
ȂŁADefWindowProc()ɓnȂƃc[o[`悳ȂȂ܂B
cƎvԈႢłBiGLtj
c[o[Ɋ֘AĂ̂͊mȂłA
ʂɂDefWindowProc()ɓnȂĂʂɕ`悳łˁcB(Win2000 SP4ł)
Ȃ̂ŁÃbZ[WKv̂ǂ܂񂪁AꉞĂ܂傤B


IMN_OPENCANDIDATE/IMN_CHANGECANDIDATE/IMN_CLOSECANDIDATE
WM_IME_COMPOSITIONnɎ悤ȕŁAĂ^C~O
 IMN_OPENCANDIDATE͕ϊ̃EBhE\ꂽ  
 IMN_CHANGECANDIDATE͕ϊꂽiMSIMEƃXy[Xj  
 IMN_CLOSECANDIDATE͕ϊ̃EBhE  
ƁAȊɂȂĂ܂B̃bZ[WDefWindowProc()ɓnȂ
ϊEBhE`悳ȂȂA ϊ񂪕`悳ȂȂ܂B 
{͂ꍇKvłA{Ɗ؍IMEgĂ͂ŖȂ̂ŖĂ܂BiP[Pj
AmȂ̂m肽lPlatformSDK̃Tv܂傤B
Ȃ݂ɁAVisualStudioƂ͕ʂ̕Platform SDK Update _E[hł܂B


*/