#include"CSound.h"
#include"Core/CSoundObjectCore.h"

#include"CSoundObject.h"
#include"../auxiliary/Debug/CTrace.h"

namespace Maid
{
CSound*	GlobalPointer<CSound>::s_pPointer;


//! RXgN^
/*!
 */
CSound::CSound()
{
	GlobalPointer<CSound>::Set();
	m_GlobalVolume = CSoundObject::VOLUME_DEFAULT;
	m_IsMute = false;
}

//! fXgN^
/*!
 */
CSound::~CSound()
{
	GlobalPointer<CSound>::Clear();
}




//! 
/*!
 */
void CSound::Initialize()
{
	//	ɂȂɂȂ
}

//! 
/*!
 */
void CSound::Finalize()
{

}


//! TEhŜ̃~[g
/*!
	@param	IsMute [i ]	true Ń~[g false ŉ
 */
void CSound::SetGlobalMute( bool IsMute )
{
	m_IsMute = IsMute;
	VolumeUpdate();
}


//! TEhŜ~[gɂȂĂ邩H
/*!
	@return	true  ~[g
\n			false 
 */
bool CSound::GetGlobalMute()
{
	return m_IsMute;
}



//! TEhŜ̃{[̐ݒ
/*!
	@param	vol [i ]	ݒ肷{[( ŏ0 - 10000 ő)
 */
void CSound::SetGlobalVolume( int vol )
{
	if( vol < VOLUME_MIN ) { vol = VOLUME_MIN; }
	if( VOLUME_MAX < vol ) { vol = VOLUME_MAX; }

	m_GlobalVolume = vol;
	VolumeUpdate();
}


//! TEhŜ̃{[̎擾
/*!
	@return	ݒ肳Ă{[( ŏ0 - 10000 ő)
 */
int  CSound::GetGlobalVolume()
{
	return m_GlobalVolume;
}



//! ǗTEhIuWFNg̒ǉ
/*!
	Cuŏ̂ŁA[U[gƂ͂Ȃ
 */
void CSound::AddSoundObject( CSoundObject* pObj )
{
	m_ObjectList.insert( pObj );
}

//! ǗTEhIuWFNg̍폜
/*!
	Cuŏ̂ŁA[U[gƂ͂Ȃ
 */
void CSound::DelSoundObject( CSoundObject* pObj )
{
	m_ObjectList.erase( pObj );
}


//! ǗĂTEhIuWFNg̃{[ύX
/*!
	Cuŏ̂ŁA[U[gƂ͂Ȃ
 */
void CSound::VolumeUpdate()
{
	for( OBJECTLIST::iterator ite=m_ObjectList.begin(); ite!=m_ObjectList.end(); ++ite )
	{
		CSoundObject* pObj = (*ite);
		if( pObj->IsNowLoading() ) { continue; }
		pObj->UpdateVolume(20);
	}
}


CSound::GLOBALINFO::GLOBALINFO()
	:Volume(5000),IsMute(false)
{
}

//! e`l̃{[̐ݒ
/*!
	@param	type [i ]	ݒ肷`l
	@param	vol  [i ]	ݒ肷{[( ŏ0 - 10000 ő)
 */
void CSound::SetVolume( int type, int vol )
{
	if( vol < VOLUME_MIN ) { vol = VOLUME_MIN; }
	if( VOLUME_MAX < vol ) { vol = VOLUME_MAX; }

	m_GlobalInfo[type].Volume = vol;

	VolumeUpdate();
}


//! e`l̃~[g̐ݒ
/*!
	@param	type   [i ]	ݒ肷`l
	@param	IsMute [i ]	true Ń~[gB false ŉ
 */
void CSound::SetMute( int type, bool IsMute )
{
	m_GlobalInfo[type].IsMute = IsMute;
	VolumeUpdate();
}

//! e`l̃{[̎擾
/*!
	@param	type [i ]	擾`l

	@return	ݒ肳Ă{[( ŏ0 - 10000 ő)
 */
int  CSound::GetVolume( int type )
{
	return m_GlobalInfo[type].Volume;
}

//! e`l̃~[gԂ̎擾
/*!
	@param	type [i ]	擾`l

	@return	true  ~[g
\n			false 
 */
bool CSound::IsMute( int type )
{
	return m_GlobalInfo[type].IsMute;
}


void CSound::PauseAll()
{
	for( OBJECTLIST::iterator ite=m_ObjectList.begin(); ite!=m_ObjectList.end(); ++ite )
	{
		CSoundObject* pObj = (*ite);
		pObj->Pause();
	}
}

void CSound::ResumeAll()
{
	for( OBJECTLIST::iterator ite=m_ObjectList.begin(); ite!=m_ObjectList.end(); ++ite )
	{
		CSoundObject* pObj = (*ite);
		pObj->UpdateVolume(0);
		pObj->Resume();
	}
}


void CSound::SendDeviceCaps()
{
	GlobalPointer<CSoundCore>::Get()->SendDeviceCaps();
}

mstring CSound::GetDeviceCaps()
{
	return GlobalPointer<CSoundCore>::Get()->GetDeviceCaps();
}

}