/*!	
	@file
	@brief	CoreƒʐMTEhIuWFNg
*/

#ifndef CSoundObjectCore_h
#define CSoundObjectCore_h

#include"../../Setup/CompileMode.h"
#include"../../template/GlobalPointer.h"
#include"CSoundCore.h"
#include"CSoundMessageImpl1.h"

namespace Maid
{
	class CSoundObjectCore;
	typedef boost::shared_ptr<CSoundObjectCore> SPSOUNDOBJECTCORE;

	class CSoundObjectCore : public GlobalPointer<CSoundCore>
	{
	public:
		CSoundObjectCore();
		~CSoundObjectCore();

		void Play();
		void Stop();

		void SetPosition( int time );
		void SetLoopPosition( int time );
		void SetVolume( int vol, int time );
		void SetPlayCount( int count );

		int	GetPosition();
		int GetPlayCount();
		bool IsPlay();

		void Delete();

		void LoadPCMStatic( const boost::shared_ptr<MySTL::vector<unt08> >& pData, int SamplesPerSec, int BitsPerSample, int Channels );
		void LoadPCMStatic( const SPSOUNDOBJECTCORE& pObj );
		void LoadPCMStream( const SPSOUNDDECODER& pDecoder );


	private:
		CSoundObjectCore( const CSoundObjectCore& rha ){}

	private:
		void PostMessage( const SPSOUNDMESSAGE& pMessage );
		const CSoundCore::BUFFERSTATUS*	m_pStatus;

	};

}


#endif
