#include"CSoundBufferPCM.h"

#include"../../../template/Mathematics.h"
#include"../../../Auxiliary/Debug/CTrace.h"
#include"../../../Auxiliary/mstring.h"

namespace Maid
{
	/*!
	 	\class	ISoundBufferPCM CSoundBufferPCM.h
	 	\brief	oblobt@NX
	 */

unt ISoundBufferPCM::GetPosition () const
{
	const unt byte_pos = GetBytePosition();

	const float pos = (float)byte_pos;
	const float bps = (float)GetBytesPerSec();

	const float ret = pos * 1000.0f / bps;

	return (unt)ret;
}

void ISoundBufferPCM::SetPosition ( unt pos )
{
	const unt itibyou = GetBytesPerSec();

	SetBytePosition( pos / 1000 * itibyou );
}

void ISoundBufferPCM::SetLoopPosition ( unt pos )
{
	const unt itibyou = GetBytesPerSec();
	const unt byte = pos / 1000 * itibyou;

	SetByteLoopPosition( byte );
}


int ISoundBufferPCM::GetBytesPerSec() const
{
	return GetSamplePerSec() * GetBitPerSample()/8 * GetChannel();
}

float	ISoundBufferPCM::GetNowRatio() const
{
	int sample = GetCurrentSample();

	if( sample==0 ) { return 0.0f; }

	const float now = (float)Math<int>::abs(sample);
	
	const float db = (float)(Math<float>::log10(now)/Math<float>::log10(65536.0f/2.0f))*100.0f;

	return db;
}


}
