#ifndef CSoundBufferStaticDS8_h
#define CSoundBufferStaticDS8_h 

/*!
 	@file
 	@brief	TEhobt@ DirectSound8
 */
#include"../../../../Setup/CompileMode.h"
#include"../CSoundBufferPCMStatic.h"
#include"DS8Include.h"

#include<vector>

namespace Maid
{
	/*!
	 	\class	CSoundBufferStaticDS8 CSoundBufferStaticDS8.h
	 	\brief	oblŜĂobt@
	 */
	class CSoundBufferStaticDS8 : public ISoundBufferPCMStatic
	{
	public:
		virtual void	Play();
		virtual void	Stop();

		virtual void	SetVolume( int vol );
		virtual int		GetVolume() const;
		virtual bool	IsPlay() const;
		virtual void	SetLoopState( bool IsLoop );
		virtual void	Update( unt time );

		virtual int	GetSamplePerSec()const;
		virtual int	GetBitPerSample()const;
		virtual int	GetChannel()const;
		virtual int	GetCurrentSample() const;


		void Setup( const SPDSBUFFER& p );

		SPDSBUFFER GetBuffer() const;

	protected:
		virtual unt GetBytePosition () const;
		virtual void SetBytePosition ( unt pos );
		virtual void SetByteLoopPosition ( unt pos ){}

	private:
		const WAVEFORMATEX* GetFormat()const;

	private:
		SPDSBUFFER	m_pBuffer;
		bool		m_IsLoop;	//	[vĐH

		MySTL::vector<unt08>	m_FormatData;

	};


}
#endif
