#ifndef CSoundDecoderOggVorbis_h
#define CSoundDecoderOggVorbis_h 


/*!
 *	\file
 *	\brief	OggVorbist@CoblɕϊC^[tF[X
 *
 *	\author cŘAiiFVj
 */

#include"CSoundDecoder.h"
#include"../../Auxiliary/FileIO/CFileRead.h"
#include<vorbis/vorbisfile.h>


namespace Maid
{
	class CSoundDecoderOggVorbis : public ISoundDecoder
	{
	public:
		CSoundDecoderOggVorbis();
		virtual ~CSoundDecoderOggVorbis();
		virtual MRESULT	Open( const MySTL::wstring& FileName );
		virtual uint32	Read( void* pDst, uint32 dwSize );
		virtual void	SetPosition( sint32 Offset, POSITION ePos );
		virtual void	Close();
		virtual uint32	GetPosition()		const;
		virtual uint32	GetLength()			const;
		virtual uint32	GetSamplesPerSec()	const;
		virtual uint32	GetChannels()		const;
		virtual uint32	GetBitsPerBlock()	const;

		virtual MRESULT  Test( const MySTL::wstring& FileName )const;
		virtual ISoundDecoder* Clone() const { return new CSoundDecoderOggVorbis; }	//!<	N[̍쐬

	private:
		CFileRead		m_hFile;

		OggVorbis_File	m_VorbisFile;

		bool			m_IsOpen;	//!<	t@CI[vĂ邩H

	private:
		static size_t	fread_emulation(void*, size_t, size_t, void*);
		static int		fseek_emulation(void*, ogg_int64_t, int);
		static int		fclose_emulation(void*);
		static long		ftell_emulation(void*);
	};
}

#endif