#ifndef CStorageObject_h
#define CStorageObject_h



#include"../Setup/CompileMode.h"
#include"FunctionEnum.h"
#include"Core/StorageObjectTemplate.h"

#include"../template/Mathematics.h"
#include"../Graphic/CSurfaceInfo.h"

namespace Maid
{
	struct TEXTUREINFO
	{
		SIZE2DI		ImageSize;
		PIXELFORMAT PixelFormat;
	};
	typedef StorageObjectTemplate<StorageDefaultFunction::LOADTEXTURE,TEXTUREINFO>	ITextureFile;

	class CSoundObjectCore;
	struct STATICPCMINFO
	{
		int SamplesPerSec;
		int BitsPerSample;
		int Channels;

		boost::shared_ptr<CSoundObjectCore> pObject;
	};

	typedef StorageObjectTemplate<StorageDefaultFunction::LOADSOUNDSTATIC,STATICPCMINFO>	ISoundFileStatic;


	struct MODELDATA
	{
		struct LAYER
		{
			struct PRIMITIVE
			{
				mstring IndexID;
				int		IndexCount;
				mstring ColorUVID;
				int		MaterialNo;
			};
			
			mstring PointID;	//	_W
			mstring NormalID;	//	@
			
			int VertexCount;

			MySTL::vector<PRIMITIVE>	Primitive;
		};
		
		struct MATERIAL
		{
			enum
			{
				TEXTURE_NONE = -1,	//	̑ɂ̓eNX`Ȃ
				ENVELOPE_NONE = -1,	//	̑ɂ̓Gx[vȂ
			};

			int		ColorTextureNo;
			float	ColorRDefault;
			//	int ColorREnvelopeNo;
			float	ColorGDefault;
			//	int ColorGEnvelopeNo;
			float	ColorBDefault;
			//	int ColorBEnvelopeNo;
			float Trance;
		};

		struct TEXTURE
		{
			int No;
			mstring FilePath;
		};
		
		MySTL::vector<LAYER>	Layer;
		MySTL::vector<MATERIAL>	Material;
		MySTL::vector<TEXTURE>	Texture;
		
		// MySTL::vector<Envelope> Envelope;
	};	

	typedef StorageObjectTemplate<StorageDefaultFunction::LOADLWO,MODELDATA>	IModelFile;


}


#endif