#ifndef StorageObjectTemplate_h
#define StorageObjectTemplate_h



#include"../../Setup/CompileMode.h"
#include"../../Auxiliary/Debug/CAssert.h"
#include"../../Auxiliary/CString.h"
#include"../../Template/GlobalPointer.h"

#include"CStorageCore.h"

namespace Maid
{
	//	t@C̓ǂݍ݂̕⏕NX

	template<int FunctionNo, class OPTION>
	class StorageObjectTemplate : public GlobalPointer<CStorageCore>
	{
	private:
		struct STORAGEINFO
		{
			int		ReferenceCount;
			int		TicketID;
			bool	IsLoadEnd;	//	ǂݍ݂H
		};

		typedef MySTL::map<mstring,STORAGEINFO> STORAGEMAP;
		static STORAGEMAP	s_Storage;

		typedef MySTL::map<mstring,OPTION> OPTIONMAP;
		static OPTIONMAP	s_Option;

		enum STATE
		{
			STATE_EMPTY,	//	܂ĂȂ
			STATE_LOADING,	//	ǂݍݒ
			STATE_WORKING,	//	ғ
		};

		STATE	m_State;
		mstring	m_FileName;

		mstring CreateID( const mstring& name ) const
		{
			//	̍ƁAłׂł͂Ȃ
			//	Linux Ƒ啶ʂ邩
			const mstring id = CString::ToLower(name);
			return id;
		}

	protected:
		virtual void LoadedDelete( const mstring& FileName )=0;
		virtual void LoadEnd( const SPSTORAGEFUNCTION_RETURNPARAM& param, OPTION& option  )=0;
		virtual void LoadEnd( const OPTION& option  ){}


	public:
		const OPTION& GetOption() const
		{
			OPTIONMAP::const_iterator ite = s_Option.find(CreateID(m_FileName));
			MAID_ASSERT( ite==s_Option.end(), "͂肦Ȃ" );

			return ite->second;
		}

		void Load( const mstring& FileName )
		{
			Delete();

			const mstring id = CreateID(FileName);
			STORAGEMAP::iterator ite = s_Storage.find(id);


			if( ite==s_Storage.end() )
			{	//	߂Ă̓ǂݍ݂AbZ[W𔭍s
				const int rettiket =  GlobalPointer<CStorageCore>::Get()->Execute( FunctionNo, FileName, SPSTORAGEFUNCTION_FUNCTIONPARAM() );

				STORAGEINFO info;

				info.IsLoadEnd = false;
				info.ReferenceCount = 1;
				info.TicketID = rettiket;

				s_Storage[id] = info;
			}
			else
			{
				//	Qڈȍ~̓LbV̂
				ite->second.ReferenceCount += 1;
			}

			m_FileName = FileName;
			m_State = STATE_LOADING;

			//	Ƃ肠ׂĂ
			IsNowLoading();
		}

		void Delete()
		{
			if( m_State==STATE_EMPTY ) { return ; }
			
			{
				//	Load() Ăłm_State==STATE_LOADING ̂܂
				//	ReferenceCountOɂȂƓǂ݂݂̓rœIȂƂȂ̂
				//	ǂݍ݂IĂXVĂj悤ɂ
				IsNowLoading();
			}

			STORAGEMAP::iterator ite = s_Storage.find(CreateID(m_FileName));
			MAID_ASSERT( ite==s_Storage.end(), "͂肦Ȃ" );
			MAID_ASSERT( ite->second.ReferenceCount==0, "肦Ȃ" );

			STORAGEINFO& info = ite->second;
			info.ReferenceCount -= 1;

			if( info.ReferenceCount==0 )
			{
				if( info.IsLoadEnd )
				{
					LoadedDelete( m_FileName );
					s_Option.erase( s_Option.find(CreateID(m_FileName)) );
				}else
				{
					GlobalPointer<CStorageCore>::Get()->Cancel( info.TicketID );
				}
				s_Storage.erase( ite );
			}

			m_FileName.clear();
			m_State = STATE_EMPTY;
		}

	public:
		mstring GetFileName() const { return m_FileName; }

		bool IsNowLoading()
		{
			MAID_ASSERT( m_State==STATE_EMPTY, "ǂݍ݂ĂȂ" );

			if( m_State==STATE_WORKING ) { return false; }

			STORAGEMAP::iterator ite = s_Storage.find(CreateID(m_FileName));
			MAID_ASSERT( ite==s_Storage.end(), "͂肦Ȃ" );
			MAID_ASSERT( ite->second.ReferenceCount==0, "肦Ȃ" );

			STORAGEINFO& info = ite->second;

			//	Ƃ肠ׂ
			if( info.IsLoadEnd )
			{
				m_State = STATE_WORKING;
				LoadEnd( s_Option[CreateID(m_FileName)] );
				return false; 
			}

			//	܂Ȃǂݍ݃Xbhɖ₢킹

			CStorageCore* pStorage = GlobalPointer<CStorageCore>::Get();

			if( pStorage->IsNowLoading( info.TicketID ) ) { return true; }

			//	܂łIĂ̂ōXV

			SPSTORAGEFUNCTION_RETURNPARAM pParam = pStorage->GetReturnParam( info.TicketID );
			
			info.IsLoadEnd = true;	//	ǂݍݏII
			m_State = STATE_WORKING;

			LoadEnd( pParam, s_Option[CreateID(m_FileName)] );

			return false;
		}

		StorageObjectTemplate()
			:m_State(STATE_EMPTY)
		{
		}

		StorageObjectTemplate( const StorageObjectTemplate<FunctionNo,OPTION>& rha )
			:m_State(STATE_EMPTY)
		{
			if( rha.m_State == STATE_EMPTY ) 
			{
				m_State = STATE_EMPTY;
				return ; 
			}

			STORAGEMAP::iterator ite = s_Storage.find(CreateID(rha.m_FileName));
			MAID_ASSERT( ite==s_Storage.end(), "͂肦Ȃ" );
			MAID_ASSERT( ite->second.ReferenceCount==0, "肦Ȃ" );

			ite->second.ReferenceCount += 1;

			m_FileName = rha.m_FileName;
			m_State = rha.m_State;
		}
		virtual ~StorageObjectTemplate()
		{
		}
	};
}


#endif