#ifndef LoadLWO_h
#define LoadLWO_h

/*!	
	@file
	@brief	LWOǂݍ
*/

#include"../../Setup/CompileMode.h"
#include"../CStorageFunction.h"

#include"../../Auxiliary/mstring.h"
#include"../../Graphic/CRenderMessageImpl3.h"

#include<boost/smart_ptr.hpp>

namespace Maid
{
	class LoadLWOReturn : public StorageFunction::IReturnParam
	{
	public:

		struct LAYER
		{
			SPBINARY		pPoint;
			SPBINARY		pNormal;

			int		VertexCount;
			int		IndexStride;	//	PCfbNX̃oCg

			struct PRIMITIVE
			{
				SPBINARY pIndex;

				int			MaterialNo;
				SPBINARY	pColorUV;
			};

			MySTL::vector<PRIMITIVE>	Primitive;
		};

		struct MATERIAL
		{
			enum
			{
				TEXTURE_NONE  = -1,	//	̑ɂ̓eNX`Ȃ
				ENVELOPE_NONE = -1,	//	̑ɂ̓Gx[vȂ
			};

			int		ColorTextureNo;
			float	ColorRDefault;
			//	int ColorREnvelopeNo;
			float	ColorGDefault;
			//	int ColorGEnvelopeNo;
			float	ColorBDefault;
			//	int ColorBEnvelopeNo;

			float Trance;
		};

		struct TEXTURE
		{
			int		No;
			mstring FilePath;
		};

		MySTL::vector<LAYER>	Layer;
		MySTL::vector<MATERIAL>	Material;
		MySTL::vector<TEXTURE>	Texture;
//		MySTL::vector<Envelope>	Envelope;
	};


	SPSTORAGEFUNCTION_RETURNPARAM LoadLWO( const mstring& FileName, const SPSTORAGEFUNCTION_FUNCTIONPARAM& pParam );
}

#endif
