/*!
 	@file
 	@brief	ꂼ̌`ɂt@CoblɕϊC^[tF[X
 */

#ifndef CSoundDecoder_h
#define CSoundDecoder_h 

#include"../../../Setup/CompileMode.h"
#include"../../../auxiliary/mstring.h"

#include<boost/smart_ptr.hpp>

namespace Maid
{
	/*!
	 	@class	ISoundDecoder CSoundDecoder.h
	 	@brief	TEht@C̊{NX
	\n			̃NXpčs܂
	 */

	class ISoundDecoder
	{
	public:

		virtual ~ISoundDecoder(){}	//!<	fXgN^

		//! t@C̃I[v
		/*!
			@param	FileName	[i ]	ǂݍރt@C
		 */
		virtual void Open( const mstring& FileName ) = 0;

		//! fR[h
		/*!
		 	@param	pDst	[i ]	܂obt@
		 	@param	dwSize	[i ]	ޗʁioCgPʁj
		 
		 	@return ۂɃfR[hʁioCgPʁj
		 */
		virtual int	Read( void* pDst, int Size )=0;

		enum POSITION
		{
			BEGIN,		//!<	t@C̐擪
			END,		//!<	t@C̏I[
			CURRENT,	//!<	݂̈ʒu
		};

		//! fR[hJnʒuړ
		/*!
		 	@param	Offset	[i ]	VʒuioCgPʁj
		 	@param	ePos	[i ]	ǂ̈ʒuړJn邩H
		 */
		virtual void SetPosition( int Offset, POSITION Pos )=0;

		//! ǂݍ񂾃t@C̉
		/*!
		 */
		virtual void Close()=0;

		//! ݂̈ʒu̎擾
		/*!
		 	@return ݂̈ʒuioCgPʁj
		 */
		virtual int GetPosition()			const= 0;

		//! Ro[g̃t@C̒擾ioCgPʒPʁj
		/*!
		 	@return t@C̒ioCgPʁj
		 */
		virtual int GetLength()			const= 0;

		//! Pb艽Tv邩̎擾
		/*!
		 	@return g
		 */
		virtual int GetSamplesPerSec()	const= 0;

		//! `l(mono,stereo )̎擾
		/*!
		 	@return `l
		 */
		virtual int GetChannels()		const= 0;

		//! PTvɎgpĂrbgʂ̎擾
		/*!
		 	@return rbg
		 */
		virtual int GetBitsPerSamples()	const= 0;

		//! PubNɎgpĂoCgʂ̎擾
		/*!
			ubNƂ 1Tv`lłPʂł

		 	@return oCg
		 */
		int GetBytePerBlock()	const
		{
			return GetChannels()*GetBitsPerSamples()/8;
		}
	};

	typedef boost::shared_ptr<ISoundDecoder> SPSOUNDDECODER;
}

#endif