#ifndef CSoundDecoderOggVorbis_h
#define CSoundDecoderOggVorbis_h 


/*!
 	@file
 	@brief	OggVorbist@CoblɕϊC^[tF[X
 */

#include"CSoundDecoder.h"
#include"../../../Auxiliary/FileIO/CFileRead.h"
#include<vorbis/vorbisfile.h>


namespace Maid
{
	class CSoundDecoderOggVorbis : public ISoundDecoder
	{
	public:
		CSoundDecoderOggVorbis();
		virtual ~CSoundDecoderOggVorbis();
		virtual void	Open( const mstring& FileName );
		virtual int		Read( void* pDst, int dwSize );
		virtual void	SetPosition( int Offset, POSITION ePos );
		virtual void	Close();
		virtual int		GetPosition()		const;
		virtual int		GetLength()			const;
		virtual int		GetSamplesPerSec()	const;
		virtual int		GetChannels()		const;
		virtual int		GetBitsPerSamples()	const;

	private:
		CFileRead		m_hFile;

		OggVorbis_File	m_VorbisFile;

		bool			m_IsOpen;	//!<	t@CI[vĂ邩H

	private:
		static size_t	fread_emulation(void*, size_t, size_t, void*);
		static int		fseek_emulation(void*, ogg_int64_t, int);
		static int		fclose_emulation(void*);
		static long		ftell_emulation(void*);
	};
}

#endif