#ifndef Collision_h
#define Collision_h

/*!
 	@file
 	@brief 낢ȓ蔻s֐
  
 	@par Ql
 \n		 @Rs[^[OtBbNX@_ƎH
 \n		 ISBN  4-274-06405-0
 \n		 oŁ@I[
  
  	@par gp
 	@code
 	if( Maid::Collision<sint32>::IsPointToRect( 0, 0, -100, -100, 100, 100 ) )
 	{
 		//	̏
 	}else
 	{
 		//	͂Ƃ̏
 	}
 	@endcode
 */
#include"../Setup/CompileMode.h"
#include"../auxiliary/macro.h"

#include"Mathematics.h"

namespace Maid
{
	/*!
	 	@class Collision Collision.h
	 	@brief 낢ȓ蔻s֐
	 */

	template<typename TYPE>
	class Collision
	{
	public:

		typedef LINE2D_TEMPLATE<TYPE> LINE2D;
		typedef POINT2D_TEMPLATE<TYPE> POINT2D;
		typedef VECTOR2D_TEMPLATE<TYPE> VECTOR2D;
		typedef RECT2D_TEMPLATE<TYPE> RECT2D;

		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! _ to lp`
		/*!
		 	@param  x			[i ]	_̍W
		 	@param  y			[i ]	_̍W
		 	@param  rect		[i ]	lp`̍W
		 
		    @return lp`̒ɓ_Ȃ true
		\n			lp`̒ɓ_ȂȂ false
		 */
		static bool IsPointToRect( const POINT2D& pos, const RECT2D_TEMPLATE<TYPE>& rect )
		{
			return IsPointToRect( pos.x, pos.y, rect.x, rect.y, rect.GetRight(), rect.GetBottom() );
		}

		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! _ to lp`
		/*!
		 	@param  x			[i ]	_̍W
		 	@param  y			[i ]	_̍W
		 	@param  rect		[i ]	lp`̍W
		 
		    @return lp`̒ɓ_Ȃ true
		\n			lp`̒ɓ_ȂȂ false
		 */
		static bool IsPointToRect( TYPE x, TYPE y, const RECT2D_TEMPLATE<TYPE>& rect )
		{
			return IsPointToRect( x, y, rect.x, rect.y, rect.GetRight(), rect.GetBottom() );
		}

		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! _ to lp`
		/*!
		 	@param  x			[i ]	_̍W
		 	@param  y			[i ]	_̍W
		 	@param  left		[i ]	lp`̍W
		 	@param  top			[i ]	lp`̍W
		 	@param  right		[i ]	lp`̍W
		 	@param  bottom		[i ]	lp`̍W
		 
		    @return lp`̒ɓ_Ȃ true
		\n			lp`̒ɓ_ȂȂ false
		 */
		static bool IsPointToRect( TYPE x, TYPE y, TYPE left, TYPE top, TYPE right, TYPE bottom )
		{
			if( left<=x && x<right )
			{
				if( top<=y && y<bottom )
				{
					return true;
				}
			}
			return false;
		}

		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! _ to 
		/*!
		 	@param  pos			[i ]	_̍W
		 	@param  rect		[i ]	̍W
		 
		    @return lp`̒ɓ_Ȃ true
		\n			lp`̒ɓ_ȂȂ false
		 */
		static bool IsPointToRect( const POINT3D_TEMPLATE<TYPE>& pos, const RECT3D_TEMPLATE<TYPE>& rect )
		{
			return IsPointToRect( pos.x, pos.y, pos.z, rect.Left, rect.Top, rect.Front, rect.Right, rect.Bottom, rect.Back );
		}

		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! _ to 
		/*!
		 	@param  x			[i ]	_̍W
		 	@param  y			[i ]	_̍W
		 	@param  z			[i ]	_̍W
		 	@param  rect		[i ]	̍W
		 
		    @return lp`̒ɓ_Ȃ true
		\n			lp`̒ɓ_ȂȂ false
		 */
		static bool IsPointToRect( TYPE x, TYPE y, TYPE z, const RECT3D_TEMPLATE<TYPE>& rect )
		{
			return IsPointToRect( x, y, z, rect.Left, rect.Top, rect.Front, rect.Right, rect.Bottom, rect.Back );
		}
		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! _ to 
		/*!
		 	@param  x			[i ]	_̍W
		 	@param  y			[i ]	_̍W
		 	@param  z			[i ]	_̍W
		 	@param  left		[i ]	lp`̍W
		 	@param  top			[i ]	lp`̍W
		 	@param  right		[i ]	lp`̍W
		 	@param  bottom		[i ]	lp`̍W
		 
		    @return lp`̒ɓ_Ȃ true
		\n			lp`̒ɓ_ȂȂ false
		 */
		static bool IsPointToRect( TYPE x, TYPE y, TYPE z, TYPE left, TYPE top, TYPE front, TYPE right, TYPE bottom, TYPE back )
		{
			if( left<=x && x<right )
			{
				if( top<=y && y<bottom )
				{
					if( front<=z && z<back )
					{
						return true;
					}
				}
			}
			return false;
		}
		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! _ to ~
		/*!
		 	@param  x		[i ]	_̍W
		 	@param  y		[i ]	_̍W
		 	@param  r		[i ]	~̔a
		 
		    @return ~̒ɓ_Ȃ true
		\n			~̒ɓ_ȂȂ false
		 */
		static bool IsPointToCircle( TYPE x, TYPE y, TYPE r )
		{
			return x*x+y*y < r*r;
		}

		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! ~ to ~
		/*!
		 	@param  x0		[i ]	~0̍W
		 	@param  y0		[i ]	~0̍W
		 	@param  r0		[i ]	~0̔a
		 	@param  x1		[i ]	~1̍W
		 	@param  y1		[i ]	~1̍W
		 	@param  r1		[i ]	~1̔a
		 
		    @return ~mԂȂ true
		\n			Ȃ false
		 */
		static bool IsCircleToCircle( TYPE x0, TYPE y0, TYPE r0, TYPE x1, TYPE y1, TYPE r1 )
		{
			const TYPE x = x0 - x1;
			const TYPE y = y0 - y1;

			const TYPE r = r0+r1;
			return x*x+y*y < r*r;
		}

		static bool IsCircleToCircle( const POINT2D& p0, TYPE r0, const POINT2D& p1, TYPE r1 )
		{
			return IsCircleToCircle( p0.x, p0.y, r0, p1.x, p1.y, r1 );
		}

		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//!  to lp`
		/*!
		 
		 	@param  Line		[i ]	
		 	@param  Rect		[i ]	`
		 
		    @return dȂĂȂTRUE
		 			dȂĂȂȂTRUE
		 */
		static bool IsLineToRect( const LINE2D& Line, const Maid::RECT2D_TEMPLATE<TYPE>& Rect  )
		{
			// `ɓĂƂ
			if( IsPointToRect( Line.p0.x, Line.p0.y, Rect ) ) { return true; }
			if( IsPointToRect( Line.p1.x, Line.p1.y, Rect ) ) { return true; }

			// `̂SӂԂĂ邩H
			const LINE2D side[4] = {
				LINE2D( Rect.Left,  Rect.Top,    Rect.Right, Rect.Top),		//	
				LINE2D( Rect.Right, Rect.Top,    Rect.Right, Rect.Bottom),	//	E
				LINE2D( Rect.Left,  Rect.Top,    Rect.Left,  Rect.Bottom),	//	
				LINE2D( Rect.Left,  Rect.Bottom, Rect.Right, Rect.Bottom),	//	
			};

			for( unt32 i=0; i<NUMELEMENTS(side); ++i )
			{
				if ( IsLineToLine( side[i], Line ) ) 
				{
					return true;
				}
			}

			return false;
		}



		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! lp` to lp`
		/*!
		 
		 	@param  Rect0		[i ]	`P
		 	@param  Rect1		[i ]	`Q
		 
		    @return dȂĂȂTRUE
		 			dȂĂȂȂTRUE
		 */
		static bool IsRectToRect( const Maid::RECT2D_TEMPLATE<TYPE>& Rect0, const Maid::RECT2D_TEMPLATE<TYPE>& Rect1 )
		{
			return IsRectToRect( Rect0.x, Rect0.y, Rect0.GetRight(), Rect0.GetBottom(),
								 Rect1.x, Rect1.y, Rect1.GetRight(), Rect1.GetBottom() );
		}
		
		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! lp` to lp`
		/*!
		 
		 	@param  left0		[i ]	`P
		 	@param  top0
		 	@param  right0
		 	@param  bottom0	
		 	@param  left1		[i ]	`Q
		 	@param  top1
		 	@param  right1
		 	@param  bottom1	
		 
		    @return dȂĂȂTRUE
		 			dȂĂȂȂTRUE
		 */
		static bool IsRectToRect( TYPE left0, TYPE top0, TYPE right0, TYPE bottom0, TYPE left1, TYPE top1, TYPE right1, TYPE bottom1 )
		{
			if ( left0   > right1 ) { return false; }
			if ( right0  < left1  ) { return false; }
			if ( top0    > bottom1) { return false; }
			if ( bottom0 < top1   ) { return false; }

			return true;
		}

		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//!  to 
		/*!
		 
		 	@param  p0x0		[i ]	P
		 	@param  p0y0
		 	@param  p1x0
		 	@param  p1y0	
		 	@param  p0x1		[i ]	Q
		 	@param  p0y1
		 	@param  p1x1
		 	@param  p1y1	
		 
		    @return ĂȂTRUE
		 			ĂȂȂTRUE
		 */
		static bool IsLineToLine( TYPE p0x0, TYPE p0y0, TYPE p1x0, TYPE p1y0, TYPE p0x1, TYPE p0y1, TYPE p1x1, TYPE p1y1 )
		{
			return IsLineToLine(	LINE2D_TEMPLATE<TYPE>(p0x0,p0y0,p1y0,p1y0),
									LINE2D_TEMPLATE<TYPE>(p0x1,p0y1,p1y1,p1y1) );
		}

		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//!  to 
		/*!
		 
		 	@param  Line1		[i ]	P
		 	@param  Line2		[i ]	Q
		 
		    @return ĂȂTRUE
		 			ĂȂȂTRUE
		 */
		static bool IsLineToLine( const LINE2D_TEMPLATE<TYPE>& Line1, const LINE2D_TEMPLATE<TYPE>& Line2 )
		{
			float32 ret1, ret2;	//	int ȂǂłƃI[o[t[Ƃ̂Ŏ^ōs

			{	//	PQĂ邩H
				const TYPE a1 = Side( Line2.p0.x, Line2.p0.y, Line1 );
				const TYPE a2 = Side( Line2.p1.x, Line2.p1.y, Line1 );
				ret1 = (float32)a1*a2;
			}
			{	//	QPĂ邩H
				const TYPE a1 = Side( Line1.p0.x, Line1.p0.y, Line2 );
				const TYPE a2 = Side( Line1.p1.x, Line1.p1.y, Line2 );
				ret2 = (float32)a1*a2;
			}

			return (ret1<=0) && (ret2<=0);
		}


		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! _̂ǂ瑤ɂ邩ׂ
		/*!
		 	@param  x			[i ]	_̍W
		 	@param  y			[i ]	_̍W
		 	@param  Line		[i ]	f[^
		  
		    @return ̉Eorɂꍇ + Ԃ
		\n			̒ɂꍇ 0 Ԃ
		\n			̍orɂꍇ - Ԃ
		 */
		static TYPE Side( TYPE x, TYPE y, const LINE2D_TEMPLATE<TYPE>& Line )
		{
			return Side( x, y, Line.p0.x, Line.p0.y, Line.p1.x, Line.p1.y );
		}

		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! _̂ǂ瑤ɂ邩ׂ
		/*!
		 	@param  x		[i ]	_̍W
		 	@param  y		[i ]	_̍W
		 	@param  p0x		[i ]	̓_P
		 	@param  p0y		[i ]	̓_P
		 	@param  p1x		[i ]	̓_Q
		 	@param  p1y		[i ]	̓_Q
		 
		    @return ̉Eɂꍇ + Ԃ
		\n			̒ɂꍇ 0 Ԃ
		\n			̍ɂꍇ - Ԃ
		 */
		static TYPE Side( TYPE x, TYPE y, TYPE p0x, TYPE p0y, TYPE p1x, TYPE p1y )
		{
			return (x-p0x)*(y-p1y) - (x-p1x)*(y-p0y);
		}

		enum
		{
			OUTCODE_TOP    = 0x01,
			OUTCODE_BOTTOM = 0x02,
			OUTCODE_RIGHT  = 0x04,
			OUTCODE_LEFT   = 0x08,
		};

		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! ƒĂ邩𒲂ׂ
		/*!
		 	߂l true ̏ꍇ pointɌĂ_Zbg
		 
		 	@param  a		[i ]	P̎n_
		 	@param  b		[i ]	P̏I_
		 	@param  c		[i ]	Q̎n_
		 	@param  d		[i ]	Q̏I_
		 	@param  point	[ o]	ĂꍇAWZbgBĂȂȂs
		 
		 	߂l	Ă true
		\n			ĂȂ false
		 */
		static bool ClipLineToLine( const POINT2D& a, const POINT2D& b, const POINT2D& c, const POINT2D& d, POINT2D& point )
		{
			const VECTOR2D V1( a, b );

			const VECTOR2D V2( c, d );

			TYPE t,s;

			{
				const TYPE tmp = V1.y * V2.x - V1.x * V2.y;
				if( tmp==0 ) { return false; }
				t   = ((a.x - c.x)*V2.y - (a.y - c.y)*V2.x) / tmp;
			}

			{
				const TYPE tmp = V2.y * V1.x - V2.x * V1.y;
				if( tmp==0 ) { return false; }
				s   = ((c.x - a.x)*V1.y - (c.y - a.y)*V1.x) / tmp;
			}

			if( 0.0f<=t && t<=1.0f && 0.0f<=s && s<=1.0f )
			{
				const TYPE x = a.x + t * V1.x;
				const TYPE y = a.y + t * V1.y;

				point.x = x;
				point.y = y;

				return true;
			}
			return false;
		}

		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! Ƌ`Ă邩𒲂ׂ
		/*!
		 	߂l true ̏ꍇ ꂼĂ_Zbg
		 
		 	@param  begin	[io]	n_
		 	@param  end		[io]	I_
		 	@param  plane	[i ]	`
		 
		 	߂l	Ă true
		\n			ĂȂ false
		 */
		static bool ClipLineToRect( POINT2D& begin, POINT2D& end, const RECT2D& plane )
		{
			// Cohen-Sutherland CNbsOASY@Ƃ炵

			unt32 out0, out1;
			bool	accept = false;	//	Ă邩
			bool	done   = false;	//	do while [vI邩

			out0 = CompOutCode( begin, plane );
			out1 = CompOutCode(   end, plane );

			do{
				if     ( (out0|out1)==0 ) { accept=true; done=true; }
				else if( (out0&out1)!=0 ) { done=true; }
				else
				{
					TYPE x,y;
					const unt32 test = out0? out0:out1;

					//	_߂
					if( test&OUTCODE_TOP )
					{
						x = begin.x+(end.x-begin.x)*(plane.y-begin.y)/(end.y-begin.y);
						y = plane.y;
					}ef( test&OUTCODE_BOTTOM )
					{
						x = begin.x+(end.x-begin.x)*(plane.GetBottom()-begin.y)/(end.y-begin.y);
						y = plane.GetBottom();
					}ef( test&OUTCODE_RIGHT )
					{
						y = begin.y+(end.y-begin.y)*(plane.GetRight()-begin.x)/(end.x-begin.x);
						x = plane.GetRight();
					}else 
					{
						y = begin.y+(end.y-begin.y)*(plane.x-begin.x)/(end.x-begin.x);
						x = plane.x;
					}


					//	_̃Zbg
					if( test==out0 )
					{
						begin.x = x;
						begin.y = y;
						out0 = CompOutCode( begin, plane );
					}else
					{
						end.x = x;
						end.y = y;
						out1 = CompOutCode( end, plane );
					}
				}

			}while( !done );

			return accept;
		}

		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! _`猩Ăǂɂ̂𒲂ׂ
		/*!
		 	߂l true ̏ꍇ ꂼĂ_Zbg
		 
		 	@param  pos		[i ]	_
		 	@param  plane	[i ]	`
		 
		 	߂l	`猩_̈ʒutOɃZbg
		\n			`̒ɂ΂O߂
		 */
		static unt CompOutCode( const POINT2D& pos, const RECT2D& plane )
		{
			unt	code = 0;

			if( pos.y < plane.x					  ) { code |= OUTCODE_TOP;    }
			ef(         plane.GetBottom() < pos.y ) { code |= OUTCODE_BOTTOM; }

			if(         plane.GetRight() < pos.x ) { code |= OUTCODE_RIGHT; }
			ef( pos.x < plane.x					 ) { code |= OUTCODE_LEFT;  }

			return code;
		}
	};
}




#endif
