/*!
 	@file
 	@brief	ʂ̃JE^ev[g
 		CC`Ă̂ŁAʂ̒lƕςȂ͂
 
 		Step𒴂 ++,-- ͓񐔔΂ɂȂƖ߂ĂȂ
 */

#ifndef NormalCounter_h
#define NormalCounter_h

#include"../../Setup/CompileMode.h"


namespace Maid
{
	/*!
	 	@class CCounter Counter.h
	 	@brief ʂ̃JE^ev[g
	 */
	template<class T, class A=T>
	class CCounter
	{
	public:
		CCounter( T Value=0 );

		CCounter<T,A>& operator++()		{ Inc(); return (*this); }
		CCounter<T,A>  operator++(int)	{ CCounter<T,A> _Tmp = *this; Inc(); return (_Tmp); }
		CCounter<T,A>& operator--()		{ Dec(); return (*this); }
		CCounter<T,A>  operator--(int)	{ CCounter<T,A> _Tmp = *this; Dec(); return (_Tmp); }

		operator T() const { return Get(); }


		void	Set( T Start, T End, int Step );

		void	Inc();
		void	Dec();
		void	Reset( int NewStep=0 ) { m_NowStep=min(m_Step,NewStep); }

		T	Get()	  const;
		T	GetStart()const	{ return m_Start;	}
		T	GetEnd()  const	{ return m_End;		}
		int	GetStep() const	{ return m_Step;	}
		int	GetNowStep()const{ return m_NowStep;}

		bool	IsEnd()   const{ return m_Step==0 || m_Step<=m_NowStep; }
		bool	IsBegin() const{ return m_Step==0 || m_NowStep<=0; }


	private:
		T	m_Start;
		T	m_End;
		int	m_Step;
		int	m_NowStep;
	};





	/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
	//! RXgN^
	/*!
	 	@param  Value		[i ]	liftHgłOj
	 */
	template<class T, class A> CCounter<T,A>::CCounter( T Value )
	{
		Set( Value, Value, 0 );
	};


	/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
	//! JE^̏
	/*!
	 	@param  Start		[i ]	l
	 	@param  End			[i ]	Il
	 	@param  Step		[i ]	IlɂȂ܂łɉCNg邩
	\n								Step==0 ̎͏ End Ԃ
	 */
	template<class T, class A>
	void CCounter<T,A>::Set( T Start, T End, int Step )
	{
		m_Start	= Start;
		m_End	= End;
		m_Step		= Step;
		m_NowStep	= 0;
	};

	/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
	//! JE^̃CNg
	/*!
	 */
	template<class T, class A>
	void CCounter<T,A>::Inc()
	{
		//	Nbv͂ȂiۂɎ擾ƂɃNbvj
		m_NowStep++;
	}


	/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
	//! JE^̃fNg
	/*!
	 */
	template<class T, class A>
	void CCounter<T,A>::Dec()
	{
		//	Nbv͂ȂiۂɎ擾ƂɃNbvj
		m_NowStep--;
	}


	/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
	//! ݂̒l擾
	/*!
		@return ݂̒l
	 */
	template<class T, class A>
	T CCounter<T,A>::Get()const
	{
		if( IsEnd()		) { return m_End;	}
		if( IsBegin()	) { return m_Start; }

		if( m_Start>m_End ) { return A(m_End) + A(m_Start-m_End) * A(m_Step-m_NowStep) / A(m_Step) ; }
		return A(m_Start) + A(m_End-m_Start) * A(m_NowStep) / A(m_Step) ;
	}
}

#endif
