/*!
 	@file
 	@brief JE^ev[gi[v@\tj
 */

#ifndef LoopCounter_h
#define LoopCounter_h


#include"../../Setup/CompileMode.h"

namespace Maid
{
	/*!
	 	@class CLoopCounter LoopCounter.h
	 	@brief JE^ev[gi[v@\tj
	 
	 	Start  Value  End ͈̔͂ Step ŉ
	 
	 	I[܂ł񂾂擪ɖ߂Ă
	 
	 	@par gp
	 	@code 
	 
	 	CLoopCounter<int> count(0);	//	0ŏ
	 
	 	count.Set( 0, 360, 7 );
	 
	 	for( int i=0; i<7; ++i )
	 	{
	 		int no = count;
	 		printf( "%d,", no );	//	0,51,102,154, 205,257,308, 0 ƕ\
	 		++count;
	 	}
	 
	 	@endcode
	 
	 	@par 悤ȃNX
	 		 CCounter
	 	*/
	template<class T, class A=T>
	class CLoopCounter
	{
	public:
		CLoopCounter( T Value= 0);

		CLoopCounter<T,A>& operator++()		{ Inc(); return (*this); }
		CLoopCounter<T,A>  operator++(int)	{ CLoopCounter<T,A> _Tmp = *this; Inc(); return (_Tmp); }
		CLoopCounter<T,A>& operator--()		{ Dec(); return (*this); }
		CLoopCounter<T,A>  operator--(int)	{ CLoopCounter<T,A> _Tmp = *this; Dec(); return (_Tmp); }

		operator T() const{ return Get(); }


		void Set( T Start, T End, int Step );
		void SetStep( int Step );

		void Inc();
		void Dec();
		void ResetStep( int NewStep=0 ) { m_NowStep=min(m_MaxStep,NewStep); }

		T	 Get()const;


		int GetLoopNum() const{ return m_LoopNum; }
		int GetStep()    const{ return m_NowStep; }

		bool	IsBegin()	const{ return m_NowStep==0; }
		bool	IsEnd()		const{ return m_NowStep==m_MaxStep-1; }

	private:
		T		m_Start;
		T		m_End;
		int		m_MaxStep;
		int		m_NowStep;
		int		m_LoopNum;
	};






/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!
 	@param  Value	[i ]	liftHgłOj
 */
template<class T, class A> CLoopCounter<T,A>::CLoopCounter( T Value )
{
	Set( Value, Value, 0 );
};


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! JE^̐ݒ
/*!	ȍ~ inc() ĂԂтɃJEgi
 
 	@param  Start	[i ]	l
 	@param  End		[i ]	Il
 	@param  Step	[i ]	End ɂȂ܂łɉCNg邩
 */
template<class T, class A>
void CLoopCounter<T,A>::Set( T Start, T End, int Step )
{
	m_Start	= Start;
	m_End	= End;
	m_MaxStep	= Step;
	m_NowStep	= 0;
	m_LoopNum  = 0;

};


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ݂̃XebvύX
/*!	
 	@param  Step	[i ]	ݒXebv
 */
template<class T, class A>
void CLoopCounter<T,A>::SetStep( int Step )
{
	m_NowStep = Step;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! JE^̃CNg
/*!	JE^I[ɂȂ珉lɖ߂
 */
template<class T, class A>
void CLoopCounter<T,A>::Inc()
{
	m_NowStep++;
	if( m_MaxStep<=m_NowStep )
	{
		m_NowStep = 0;
		m_LoopNum++;
	}
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! JE^̃fNg
/*!	JE^lɂȂI[lɖ߂
 */
template<class T, class A>
void CLoopCounter<T,A>::Dec()
{
	m_NowStep--;
	if( m_NowStep<0 )
	{
		m_NowStep = m_MaxStep-1;
		m_LoopNum--;
	}
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ݂̒l擾
/*!	lQƂƂ͂\n
 	e|ɃRs[ق
 
 	@return ݂̂
 */
template<class T, class A>
T CLoopCounter<T,A>::Get()const
{
	if( m_MaxStep==0 ) { return m_End; }
	if( m_Start>m_End ) { return A(m_End) + A(m_Start-m_End) * A(m_MaxStep-m_NowStep) / A(m_MaxStep) ; }
	return A(m_Start) + A(m_End-m_Start) * A(m_NowStep) / A(m_MaxStep);
}
}

#endif
