/*!
 	@file
 	@brief	wev[g
 */

#ifndef Mathematics_h
#define Mathematics_h

#include"../Setup/CompileMode.h"

#include"Mathematics/Point.h"
#include"Mathematics/Line.h"
#include"Mathematics/Size.h"
#include"Mathematics/Rect.h"
#include"Mathematics/Vector.h"
#include"Mathematics/Matrix.h"
#include"Mathematics/Quaternion.h"

#include"Mathematics/function.h"



//	e퍇
namespace Maid
{
	//	Point + Vector
	template<typename TYPE>	POINT2D_TEMPLATE<TYPE> operator+( const POINT2D_TEMPLATE<TYPE>& lha, const VECTOR2D_TEMPLATE<TYPE>& rha ){ return POINT2D_TEMPLATE<TYPE>( lha.x+rha.x, lha.y+rha.y); }
	template<typename TYPE>	POINT3D_TEMPLATE<TYPE> operator+( const POINT3D_TEMPLATE<TYPE>& lha, const VECTOR3D_TEMPLATE<TYPE>& rha ){ return POINT3D_TEMPLATE<TYPE>( lha.x+rha.x, lha.y+rha.y, lha.z+rha.z); }
	template<typename TYPE>	POINT4D_TEMPLATE<TYPE> operator+( const POINT4D_TEMPLATE<TYPE>& lha, const VECTOR4D_TEMPLATE<TYPE>& rha ){ return POINT4D_TEMPLATE<TYPE>( lha.x+rha.x, lha.y+rha.y, lha.z+rha.z, lha.w+rha.w); }

	//	Point += Vector
	template<typename TYPE>	POINT2D_TEMPLATE<TYPE>& operator+=( POINT2D_TEMPLATE<TYPE>& lha, const VECTOR2D_TEMPLATE<TYPE>& rha ){ lha.x+=rha.x; lha.y+=rha.y; return lha;}
	template<typename TYPE>	POINT3D_TEMPLATE<TYPE>& operator+=( POINT3D_TEMPLATE<TYPE>& lha, const VECTOR3D_TEMPLATE<TYPE>& rha ){ lha.x+=rha.x; lha.y+=rha.y; lha.z+=rha.z; return lha;}
	template<typename TYPE>	POINT4D_TEMPLATE<TYPE>& operator+=( POINT4D_TEMPLATE<TYPE>& lha, const VECTOR4D_TEMPLATE<TYPE>& rha ){ lha.x+=rha.x; lha.y+=rha.y; lha.z+=rha.z; lha.w+=rha.w; return lha;}

	//	Point - Vector
	template<typename TYPE>	POINT2D_TEMPLATE<TYPE> operator-( const POINT2D_TEMPLATE<TYPE>& lha, const VECTOR2D_TEMPLATE<TYPE>& rha ){ return POINT2D_TEMPLATE<TYPE>( lha.x-rha.x, lha.y-rha.y); }
	template<typename TYPE>	POINT3D_TEMPLATE<TYPE> operator-( const POINT3D_TEMPLATE<TYPE>& lha, const VECTOR3D_TEMPLATE<TYPE>& rha ){ return POINT3D_TEMPLATE<TYPE>( lha.x-rha.x, lha.y-rha.y, lha.z-rha.z); }
	template<typename TYPE>	POINT4D_TEMPLATE<TYPE> operator-( const POINT4D_TEMPLATE<TYPE>& lha, const VECTOR4D_TEMPLATE<TYPE>& rha ){ return POINT4D_TEMPLATE<TYPE>( lha.x-rha.x, lha.y-rha.y, lha.z-rha.z, lha.w-rha.w); }

	//	Point -= Vector
	template<typename TYPE>	POINT2D_TEMPLATE<TYPE>& operator-=( POINT2D_TEMPLATE<TYPE>& lha, const VECTOR2D_TEMPLATE<TYPE>& rha ){ lha.x-=rha.x; lha.y-=rha.y; return lha;}
	template<typename TYPE>	POINT3D_TEMPLATE<TYPE>& operator-=( POINT3D_TEMPLATE<TYPE>& lha, const VECTOR3D_TEMPLATE<TYPE>& rha ){ lha.x-=rha.x; lha.y-=rha.y; lha.z-=rha.z; return lha;}
	template<typename TYPE>	POINT4D_TEMPLATE<TYPE>& operator-=( POINT4D_TEMPLATE<TYPE>& lha, const VECTOR4D_TEMPLATE<TYPE>& rha ){ lha.x-=rha.x; lha.y-=rha.y; lha.z-=rha.z; lha.w-=rha.w; return lha;}
}



#endif