/*!
 	@file
 	@brief	QxNgev[g
 */



#ifndef Vector2D_h
#define Vector2D_h

#include"../../Setup/CompileMode.h"

#include"Point2D.h"
#include"function.h"

namespace Maid
{ 
	/*!
	 	@brief	QxNgێ\
	 */
	template<typename TYPE>
	struct VECTOR2D_TEMPLATE
	{ 
		typedef VECTOR2D_TEMPLATE<TYPE> VECTOR;
		typedef POINT2D_TEMPLATE<TYPE>  POINT;

		TYPE	x;		//!<	
		TYPE	y;		//!<	c

		VECTOR2D_TEMPLATE(){}		//!	RXgN^
		VECTOR2D_TEMPLATE( TYPE _x, TYPE _y ): x(_x), y(_y){}
		VECTOR2D_TEMPLATE( const POINT& Start, const POINT& End ) { Reset(Start,End); }
		
		//! K
		/*!
		*/
		const VECTOR& Normalize()
		{
			const TYPE f = Math<TYPE>::sqrt(x*x+y*y);
			*this /= f;
			return *this;
		}

		//! WxNgɕϊ
		/*!
		 	@param	Start [i ]	xNg̊JnW
		 	@param	End   [i ]	xNg̏IW
		 */
		void Reset( const POINT& Start, const POINT& End )
		{
			x = End.x-Start.x;
			y = End.y-Start.y;
		}

		//! WxNgɕϊ
		/*!
		 	@param	pos [i ]	xNg̊JnW
		 */
		void Reset( const POINT& pos )
		{
			x = pos.x;
			y = pos.y;
		}

		POINT ConvertPOINT2D() { return POINT(x,y); }

		//	PZq
		VECTOR operator-() const{ return VECTOR(-x,-y); }

		//	rZq
		bool operator==( const VECTOR& rha ) const{ return x==rha.x && y==rha.y; }
		bool operator!=( const VECTOR& rha ) const{ return !(*this==rha); }

		//	Đݒ
		VECTOR& operator+=( const VECTOR& rha)	{ *this = *this+rha; return *this; }
		VECTOR& operator-=( const VECTOR& rha)	{ *this = *this-rha; return *this; }
		VECTOR& operator*=( const TYPE& val)	{ *this = *this*val; return *this; }
		VECTOR& operator/=( const TYPE& val)	{ *this = *this/val; return *this; }
	};


	//	񍀉Zq
	template<typename TYPE>
	VECTOR2D_TEMPLATE<TYPE> operator+( const VECTOR2D_TEMPLATE<TYPE>& lha, const VECTOR2D_TEMPLATE<TYPE>& rha )
	{
		return VECTOR2D_TEMPLATE<TYPE>( lha.x+rha.x, lha.y+rha.y); 
	}
	template<typename TYPE>
	VECTOR2D_TEMPLATE<TYPE> operator-( const VECTOR2D_TEMPLATE<TYPE>& lha, const VECTOR2D_TEMPLATE<TYPE>& rha )
	{
		return VECTOR2D_TEMPLATE<TYPE>( lha.x-rha.x, lha.y-rha.y); 
	}
	template<typename TYPE>
	VECTOR2D_TEMPLATE<TYPE> operator*( const VECTOR2D_TEMPLATE<TYPE>& lha, const TYPE& rha )
	{
		return VECTOR2D_TEMPLATE<TYPE>( lha.x*rha, lha.y*rha); 
	}
	template<typename TYPE>
	VECTOR2D_TEMPLATE<TYPE> operator/( const VECTOR2D_TEMPLATE<TYPE>& lha, const TYPE& rha )
	{
		return VECTOR2D_TEMPLATE<TYPE>( lha.x/rha, lha.y/rha); 
	}

	//! ς߂
	/*!
	 	@param	lha		[i ]	xNĝP
	 	@param	rha		[i ]	xNĝQ
	 
	 	@return	ς̒l
	 */
	template<typename TYPE>
	inline TYPE VectorDot( const VECTOR2D_TEMPLATE<TYPE>& lha, const VECTOR2D_TEMPLATE<TYPE>& rha )
	{
		return (lha.x*rha.x) + (lha.y*rha.y);
	}
}

//	Windows ̂Ƃ̂ DXLIB go[W𑶍݂
#ifdef USE_DIRECT3DX9
	#include<d3dx9.h>
	#pragma comment( lib, "d3dx9.lib" )

	namespace Maid
	{
		const VECTOR2D_TEMPLATE<FLOAT>& VECTOR2D_TEMPLATE<FLOAT>::Normalize()
		{
			D3DXVec2Normalize( (D3DXVECTOR2*)this, (D3DXVECTOR2*)this );
			return *this;
		}

		inline FLOAT VectorDot( const VECTOR2D_TEMPLATE<FLOAT>& lha, const VECTOR2D_TEMPLATE<FLOAT>& rha )
		{
			return D3DXVec2Dot( (D3DXVECTOR2*)&lha, (D3DXVECTOR2*)&rha );
		}
	}
#endif

#endif
