/*!
 	@file
 	@brief	SxNgev[g
 */



#ifndef Vector4D_h
#define Vector4D_h

#include"../../Setup/CompileMode.h"

#include"Point4D.h"
#include"function.h"


namespace Maid
{ 
	/*!
	 	@brief	SxNgێ\
	 */
	template<typename TYPE>
	struct VECTOR4D_TEMPLATE
	{ 
		typedef VECTOR4D_TEMPLATE<TYPE> VECTOR;
		typedef POINT4D_TEMPLATE<TYPE>  POINT;

		TYPE	x;		//!<	
		TYPE	y;		//!<	c
		TYPE	z;		//!<	
		TYPE	w;		//!<	w?

		VECTOR4D_TEMPLATE(){}
		//!	RXgN^
		VECTOR4D_TEMPLATE( TYPE _x, TYPE _y, TYPE _z, TYPE _w ): x(_x), y(_y), z(_z), w(_w){}
		VECTOR4D_TEMPLATE( const POINT& Start, const POINT& End ) {	Reset(Start,End); }
		

		//! K
		/*!
		*/
		const VECTOR& Normalize()
		{
			const TYPE f = Math<TYPE>::sqrt(x*x+y*y+z*z+w*w);
			*this /= f;
			return *this;
		}

		//! WxNgɕϊ
		/*!
		 	@param	Start [i ]	xNg̊JnW
		 	@param	End   [i ]	xNg̏IW
		 */
		void Reset( const POINT& Start, const POINT& End )
		{
			x = End.x-Start.x;
			y = End.y-Start.y;
			z = End.z-Start.z;
			w = End.w-Start.w;
		}
		//! WxNgɕϊ
		/*!
		 	@param	pos [i ]	xNg̊JnW
		 */
		void Reset( const POINT& pos )
		{
			x = pos.x;
			y = pos.y;
			z = pos.z;
			w = pos.w;
		}

		//	PZq
		VECTOR operator-() const{ return VECTOR(-x,-y,-z,-w); }

		//	rZq
		bool operator==( const VECTOR& rha ) const{ return x==rha.x && y==rha.y && z==rha.z && w==rha.w; }
		bool operator!=( const VECTOR& rha ) const{ return !(*this==rha); }

		//	Đݒ
		VECTOR& operator+=( const VECTOR& rha)	{ *this = *this+rha; return *this; }
		VECTOR& operator-=( const VECTOR& rha)	{ *this = *this-rha; return *this; }
		VECTOR& operator*=( const TYPE& val)	{ *this = *this*val; return *this; }
		VECTOR& operator/=( const TYPE& val)	{ *this = *this/val; return *this; }

	};

	//	񍀉Zq
	template<typename TYPE>
	VECTOR4D_TEMPLATE<TYPE> operator-( const VECTOR4D_TEMPLATE<TYPE>& lha, const VECTOR4D_TEMPLATE<TYPE>& rha )
	{
		return VECTOR4D_TEMPLATE<TYPE>( lha.x-rha.x, lha.y-rha.y, lha.z-rha.z, lha.w-rha.w); 
	}
	template<typename TYPE>
	VECTOR4D_TEMPLATE<TYPE> operator+( const VECTOR4D_TEMPLATE<TYPE>& lha, const VECTOR4D_TEMPLATE<TYPE>& rha )
	{
		return VECTOR4D_TEMPLATE<TYPE>( lha.x+rha.x, lha.y+rha.y, lha.z+rha.z, lha.w+rha.w); 
	}
	template<typename TYPE>
	VECTOR4D_TEMPLATE<TYPE> operator*( const VECTOR4D_TEMPLATE<TYPE>& lha, const TYPE& rha )
	{
		return VECTOR4D_TEMPLATE<TYPE>( lha.x*rha, lha.y*rha, lha.z*rha, lha.w*rha); 
	}
	template<typename TYPE>
	VECTOR4D_TEMPLATE<TYPE> operator/( const VECTOR4D_TEMPLATE<TYPE>& lha, const TYPE& rha )
	{
		return VECTOR4D_TEMPLATE<TYPE>( lha.x/rha, lha.y/rha, lha.z/rha, lha.w/rha); 
	}

	//! ς߂
	/*!
	 	@param	lha		[i ]	xNĝP
	 	@param	rha		[i ]	xNĝQ
	 
	 	@return	ς̒l
	 */
	template<typename TYPE>
	inline TYPE VectorDot( const VECTOR4D_TEMPLATE<TYPE>& lha, const VECTOR4D_TEMPLATE<TYPE>& rha )
	{
		return (lha.x*rha.x) + (lha.y*rha.y) + (lha.z*rha.z) + (lha.w*rha.w);
	}


}
	//	Windows ̂Ƃ̂ DXLIB go[W𑶍݂
	#ifdef USE_DIRECT3DX9
		#include<d3dx9.h>
		#pragma comment( lib, "d3dx9.lib" )

		namespace Maid
		{

			const VECTOR4D_TEMPLATE<FLOAT>& VECTOR4D_TEMPLATE<FLOAT>::Normalize()
			{
				D3DXVec4Normalize( (D3DXVECTOR4*)this, (D3DXVECTOR4*)this );
				return *this;
			}

			inline FLOAT VectorDot( const VECTOR4D_TEMPLATE<FLOAT>& lha, const VECTOR4D_TEMPLATE<FLOAT>& rha )
			{
				return D3DXVec4Dot( (D3DXVECTOR4*)&lha, (D3DXVECTOR4*)&rha );
			}
		}
	#endif


#endif
