/*!
 	@file
 	@brief	wZev[g
 */



#ifndef Function_h
#define Function_h

#include"../../Setup/CompileMode.h"

#include<cmath>

namespace Maid
{ 
	/*!
	 	@class Math Function.h
	 	@brief 낢ȐwZs֐
	 */

	template<typename TYPE>
	class Math
	{
	public:
		static TYPE sin( TYPE rad ) { return MySTL::sin(rad); }
		static TYPE cos( TYPE rad ) { return MySTL::cos(rad); }
		static TYPE tan( TYPE rad ) { return MySTL::tan(rad); }
		static TYPE atan2( TYPE y, TYPE x ) { return MySTL::atan2(y,x); }
		static TYPE sqrt( TYPE rad ) { return MySTL::sqrt(rad); }
		static TYPE log10( TYPE val ) { return MySTL::log10(val); }
		static TYPE pow( TYPE x, TYPE y ) { return MySTL::pow(x,y); }
		static TYPE abs( TYPE x ) { return MySTL::abs(x); }

		static TYPE b_spline( TYPE x1, TYPE x2, TYPE x3, TYPE time )
		{
			const TYPE t  = time;
			const TYPE it = 1-time;

			return (it*it*x1) + (2*t*it*x2) + (t*t*x3);
		}
	};
}

#endif