#ifndef ReferenceCount_h
#define ReferenceCount_h

#include"../Setup/CompileMode.h"
#include"../Auxiliary/Debug/CAssert.h"
#include"../Auxiliary/Debug/CWarning.h"
#include"../Auxiliary/Debug/CException.h"

#include<map>

namespace Maid
{ 
	/*!
	 	@brief	QƃJE^
	\n			g CPixelShader ݂Ă
	 */
	template <class KEY>
	class ReferenceCount
	{
	private:
		typedef MySTL::map<KEY,unt> COUNTMAP;
		COUNTMAP	m_CountMap;

	public:

		~ReferenceCount()
		{
/*
			for( COUNTMAP::iterator ite=m_CountMap.begin(); ite!=m_CountMap.end(); ++ite )
			{
				MAID_WARNING( MAIDTEXT("JE^cĂ܂:") << ite->first );
			}
*/
		}

		//! QƃJE^𑝂₷
		/*!
			@param	k	[i ]	₷L[

			@return L[ꂽꍇ true
					JE^邾̏ꍇ false
		 */
		bool Add( const KEY& k )
		{
			//	LbV̌
			COUNTMAP::iterator ite = m_CountMap.find(k);

			if( ite!=m_CountMap.end() )
			{
				//	łɑ݂ĂȂJE^𑝂₷
				ite->second += 1;
				return false;
			}

			//	ȂȂ瑝₷
			m_CountMap[k] = 1;
			return true;
		}

		//! QƃJE^炷
		/*!
			@param	k	[i ]	炷L[

			@return L[폜ꂽꍇ true
					JE^邾̈ȊO false
		 */
		bool Del( const KEY& k )
		{
			COUNTMAP::iterator ite = m_CountMap.find(k);

			MAID_ASSERT( ite==m_CountMap.end(), MAIDTEXT("L[݂Ȃ̂ɌĂ΂܂ ") << k );

			ite->second -= 1;

			if( ite->second != 0 )
			{
				return false;
			}

			m_CountMap.erase( ite );
			return true;
		}

	};
}

#endif