#include"../../Maid/FrameWork/Windows/CSingleWindowAppWindows.h"

#include"../../Maid/Graphic/CGraphic.h"

#include"../../Maid/Graphic/CPixelShader.h"
#include"../../Maid/Graphic/CVertexShader.h"
#include"../../Maid/Graphic/CVertexMemory.h"

#include"../../Maid/Graphic/CCustomVertexTemplate.h"
#include"../../Maid/Auxiliary/FileIO/CFileRead.h"

using namespace Maid;


class CApp : public IGameThread
{
protected:
	void OnLocalSetup( APPCONFIG& conf )
	{

	}

	void OnLocalEnd()
	{

	}

	void OnLocalBegin( const BEGINPARAM& param )
	{
		CFileRead::GetPackFile().Mount( MAIDTEXT("samplearchive.dat") );

		{
			MySTL::vector<unt08> tmp1, tmp2;
			CFileRead::Read( MAIDTEXT("samplearchive/test1.txt"), tmp1 );
			CFileRead::Read( MAIDTEXT("samplearchive/box_texture.bmp"), tmp2 );

			int k=0;
		}


		{
			CGraphic::SCREENMODE m;

			m.Mode = CGraphic::SCREENMODE::TYPE_WINDOW;
			m.Size = SIZE2DI(800,600);
			m.RefreshRate = 0;
			m.IsSoftTnL = false;
			m.IsWaitVSync = true;
			m.IsAspectLock = false;

			m_Graphic.Initialize( m, param.pFontDriver, param.pInfo );
		}
		{
			vs.Create( VERTEXSHADERNAME::RHWCOLOR );
			ps.Create( PIXELSHADERNAME::VERTEXCOLOR_ADD );

			{
				CUSTOMVERTEX_COLOR v[] =
				{
					CUSTOMVERTEX_COLOR(POINT3DF(100,100,0), 1.0f, COLOR_A08R08G08B08I(0xFF,0xFF,0x00,0x00) ),
					CUSTOMVERTEX_COLOR(POINT3DF(100,200,0), 1.0f, COLOR_A08R08G08B08I(0xFF,0xFF,0x00,0x00) ),
					CUSTOMVERTEX_COLOR(POINT3DF(200,100,0), 1.0f, COLOR_A08R08G08B08I(0xFF,0xFF,0x00,0x00) ),
				};

				vertex.Create( v[0].GetVertexFormat(), v, NUMELEMENTS(v) );
			}
		}
	}

	void OnLocalLoop()
	{
		//	ŕ`施߂o
		m_Graphic.ClearRenderTargetColor( COLOR_A08R08G08B08I(0xFF,0x00,0x00,0x80) );

		//	2Dȕ`(`hԂ)
		m_Graphic.Fill( RECT2DI(150,100,100,100), COLOR_A08R08G08B08I(0xFF,0x00,0xFF,0x00) );

		//	ł낢ݒ肵ĕ`
		{

			m_Graphic.SetVertexShader( vs );
			m_Graphic.SetPixelShader( ps );
			m_Graphic.SetVertex( vertex );
			m_Graphic.DrawPrimitive( CGraphic::PRIMITIVE_TRIANGLESTRIP, 0, 1 );
		}


		//	̃t[
		OnNextFrame(m_Graphic);
		::Sleep(100);
	}


private:
	CGraphic		m_Graphic;
	CVertexShaderDefault vs;	//	_ϊς݂̒__F̂܂܂ȂVF[_[
	CPixelShaderDefault ps;	//	ZsNZVF[_[
	CVertexMemory vertex;
};


int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow )
{
	CSingleWindowAppWindows capp( SPGAMETHREAD( new CApp ) );
	return capp.Run( hInstance, hPrevInstance, lpCmdLine, nCmdShow );
}