#include"../../Maid/FrameWork/Windows/CSingleWindowAppWindows.h"

#include"../../Maid/Graphic/CGraphic.h"
#include"../../Maid/Graphic/CTextureFile.h"

#include"../../Maid/Storage/CStorage.h"

#include"../../Maid/Auxiliary/CString.h"

#include"../../Maid/Input/CMouse.h"
#include"../../Maid/Input/CKeybord.h"



using namespace Maid;


class CApp : public IGameThread
{
protected:
	void OnLocalSetup( APPCONFIG& conf )
	{

	}

	void OnLocalEnd()
	{

	}

	void OnLocalBegin( const BEGINPARAM& param )
	{
		{
			CGraphic::SCREENMODE m;

			m.Mode = CGraphic::SCREENMODE::TYPE_WINDOW;
			m.Size = SIZE2DI(800,600);
			m.RefreshRate = 0;
			m.IsSoftTnL = false;
			m.IsWaitVSync = true;
			m.IsAspectLock = false;

			m_Graphic.Initialize( m, param.pFontDriver, param.pInfo );
		}
		{
			//	Xg[W̏
			m_Storage.Initialize( );
		}
		{
			//	L[͂̏
			m_Mouse.Initialize( param.pMouseDriver );
			m_Keybord.Initialize( param.pKeybordDriver, param.pCharCodeDriver );
		}


		//	tHg̍쐬
		 pFont = m_Graphic.CreateFont( 0, SIZE2DI(16,32), true, false, false );

	}

	void OnLocalLoop()
	{
		//	}EX̍XV
		m_Mouse.Update();

		//	L[{[h̍XV
		m_Keybord.Update();

		//	ʂ̃NA
		m_Graphic.ClearRenderTargetColor( COLOR_A08R08G08B08I(0xFF,0x00,0x00,0x80) );


		{	//	}EXW\
			char buf[256];
			sprintf( buf, "}EXW:%04d,%04d", m_Mouse.GetX(), m_Mouse.GetY() );
			m_Graphic.BltText( POINT2DF(0,0), pFont, COLOR_A08R08G08B08I(0xFF,0xFF,0xFF,0xFF), CString::ConvertSJIStoMAID(buf) );
		}

		if( m_Keybord.IsDown('A' ) )
		{	//	L[{[h`Ă邩H
			m_Graphic.BltText( POINT2DF(0,32), pFont, COLOR_A08R08G08B08I(0xFF,0xFF,0xFF,0xFF), MAIDTEXT("`Ă܂") );

		}

		if( m_Keybord.IsIn('B') )
		{	//	L[{[haꂽuԂH
			m_Graphic.BltText( POINT2DF(0,64), pFont, COLOR_A08R08G08B08I(0xFF,0xFF,0xFF,0xFF), MAIDTEXT("aI") );

		}

		//	̃t[
		OnNextFrame(m_Graphic);
		::Sleep(50);
	}


private:
	CGraphic	m_Graphic;
	CStorage	m_Storage;
	CMouse		m_Mouse;
	CKeybord	m_Keybord;
	SPFONT		pFont;


};


int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow )
{
	CSingleWindowAppWindows capp( SPGAMETHREAD( new CApp ) );
	return capp.Run( hInstance, hPrevInstance, lpCmdLine, nCmdShow );
}