#include"../../Maid/FrameWork/Windows/CApplicationWindows.h"

#include"../../Maid/auxiliary/FileIO/CFileWrite.h"
#include"../../Maid/auxiliary/Windows/CShell.h"
#include"../../Maid/auxiliary/Debug/CAssert.h"
#include"../../Maid/auxiliary/CString.h"

#include"resource.h"

using namespace Maid;

/*!
 *  \file
 *  \brief	܂ł Windows Ȃ݂ WinMain
 *
 */


static const char* s_COPIERNAME = "MaidInstaller0101.exe";
static const char* s_COPIERCOMMAND = "config.xml";




class CApp : public IApplicationWindows
{
protected:
	virtual void OnSetup(){}
	virtual void OnCleanup(){}

	virtual void OnLoop()
	{
		const mstring CopierPath    = CShell::GetWindowsFolder() + MAIDTEXT("\\") + MAIDTEXT(s_COPIERNAME);
		const mstring CopierCommand = CShell::GetCurrentDirectory() + MAIDTEXT("\\") + MAIDTEXT(s_COPIERCOMMAND);

		{
			//	CXg[[̃Rs[

			HRSRC hResource = FindResource( NULL, MAKEINTRESOURCE(IDR_INSTALLER1), "installer" );

			MAID_ASSERT( hResource==NULL, "installer.exe ܂ł" );
			const DWORD ExeSize = SizeofResource( NULL,hResource);

			HGLOBAL hGlobal = LoadResource( NULL, hResource );

			void* pExeImage = LockResource( hGlobal );

			CFileWrite::Write( CopierPath, pExeImage, ExeSize );

			FreeResource( hGlobal );
		}

		{
			const mstring line = CopierPath + MAIDTEXT(" \"") + CopierCommand + MAIDTEXT("\"");

			PROCESS_INFORMATION pi;
			STARTUPINFO si;

			ZeroMemory(&si,sizeof(si));
			si.cb=sizeof(si);

			CreateProcess(NULL,(LPTSTR)CString::ConvertMAIDtoSJIS(line).c_str(),NULL,NULL,FALSE,NORMAL_PRIORITY_CLASS,
				NULL,NULL,&si,&pi);
		}

		ApplicationExit();
	}
};


int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow )
{
	CApp capp;
	return capp.Run( hInstance, hPrevInstance, lpCmdLine, nCmdShow );
}
